/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.multitenant;

import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.multitenant.AuditableServerServiceInstanceHandler;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.OMAGServerInstanceErrorCode;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorProvider;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;

public class GovernanceServerServiceInstanceHandler
extends AuditableServerServiceInstanceHandler {
    protected final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();

    public GovernanceServerServiceInstanceHandler(String serviceName) {
        super(serviceName);
    }

    public ConnectorType validateConnector(String connectorProviderClassName, Class<?> requiredConnectorInterface, String serviceName) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        String providerClassNameParameterName = "connectorProviderClassName";
        String requiredConnectorInterfaceParameterName = "requiredConnectorInterface";
        String testConnectionQualifiedName = "testConnection";
        String methodName = "validateConnector";
        this.invalidParameterHandler.validateName(connectorProviderClassName, "connectorProviderClassName", "validateConnector");
        this.invalidParameterHandler.validateObject(requiredConnectorInterface, "requiredConnectorInterface", "validateConnector");
        Class<?> connectorProviderClass = Class.forName(connectorProviderClassName);
        Object potentialConnectorProvider = connectorProviderClass.newInstance();
        ConnectorProvider connectorProvider = (ConnectorProvider)potentialConnectorProvider;
        ConnectorType connectorType = connectorProvider.getConnectorType();
        if (connectorType == null) {
            connectorType = new ConnectorType();
            connectorType.setConnectorProviderClassName(connectorProviderClassName);
        }
        Connection testConnection = new Connection();
        testConnection.setQualifiedName("testConnection");
        testConnection.setConnectorType(connectorType);
        Connector connector = connectorProvider.getConnector(testConnection);
        if (!requiredConnectorInterface.isInstance(connector)) {
            throw new InvalidParameterException(OMAGServerInstanceErrorCode.NOT_CORRECT_CONNECTOR_PROVIDER.getMessageDefinition(connectorProviderClassName, requiredConnectorInterface.getCanonicalName(), serviceName), this.getClass().getName(), "validateConnector", connectorProviderClassName);
        }
        return connectorType;
    }
}

