/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.multitenant.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageSet;

public enum OMAGServerInstanceErrorCode implements ExceptionMessageSet
{
    BAD_SERVER_SECURITY_CONNECTION(400, "OMAG-MULTI-TENANT-400-001", "The OMAG server {0} has been configured with a bad connection to its security connector.  Error message is {1}. Connection is {2}", "The system is unable to validate the users issuing requests to this server.", "Review the error message to determine the cause of the problem."),
    SERVICES_NOT_SHUTDOWN(400, "OMAG-MULTI-TENANT-400-002", "The OMAG server {0} has been requested to shutdown but the following services are still running: {1}", "The system is unable to shutdown the server correctly.", "Review other error messages to determine the cause of the problem.  This is likely to be a logic error in the services listed in the message"),
    NO_TOPIC_INFORMATION(400, "OMAG-MULTI-TENANT-400-003", "Method {0} called on behalf of the {1} service is unable to create a client-side open metadata topic connection because the topic name is not configured in the configuration for this service.", "This is a configuration error and an exception is sent to the requester.", "Correct the configuration of the access service to include the name of the topic."),
    NOT_CORRECT_CONNECTOR_PROVIDER(400, "OMAG-MULTI-TENANT-400-004", "The connector provider class name {0} does not create a connector of class {1} which is required for the {2}", "An invalid parameter exception is returned to the caller.", "Either change the connector or the hosting environment because the current combination is not compatible."),
    SERVER_NOT_AVAILABLE(404, "OMAG-MULTI-TENANT-404-001", "The OMAG Server {0} is not available to service a request from user {1}", "The system is unable to process the request because the server is not running on the called platform.", "Verify that the correct server is being called on the correct platform and that this server is running. Retry the request when the server is available."),
    SERVICE_NOT_AVAILABLE(404, "OMAG-MULTI-TENANT-404-002", "The {0} service is not available on OMAG Server {1} to handle a request from user {2}", "The system is unable to process the request because the service is not available.", "Verify that the correct server is being called on the correct platform and that the requested service is configured to run there.  Once the correct environment is in place, retry the request."),
    SERVER_NAME_NOT_AVAILABLE(404, "OMAG-MULTI-TENANT-404-003", "The server name is not available for the {0} operation", "The system is unable to return the server name because it is not available.", "Check that the server where the access service is running initialized correctly.  Correct any errors discovered and retry the request when the open metadata services are available."),
    OMRS_NOT_INITIALIZED(404, "OMAG-MULTI-TENANT-404-004", "The open metadata repository services are not initialized for the {0} operation", "The system is unable to connect to the open metadata repository services because they are not running in this server.", "Check that the server where the called service is running initialized correctly.  Correct any errors discovered and retry the request when the open metadata services are available."),
    OMRS_NOT_AVAILABLE(404, "OMAG-MULTI-TENANT-404-005", "The open metadata repository services are not available for the {0} operation", "The system is unable to connect to the open metadata repository services because they are not in the correct state to be called.", "Check that the server where the called service is running initialized correctly and is not in the process of shutting down.  Correct any errors discovered and retry the request when the open metadata repository services are available."),
    BAD_TOPIC_CONNECTOR_PROVIDER(500, "OMAG-MULTI-TENANT-500-003", "Method {0} called on behalf of the {1} service detected a {2} exception when creating an open metadata topic connection because the connector provider is incorrect.  The error message was {3}", "This is an internal error.  The access service is not using a valid connector provider.", "Raise an issue on Egeria's GitHub and work with the Egeria community to resolve.");

    private ExceptionMessageDefinition messageDefinition;

    private OMAGServerInstanceErrorCode(int httpErrorCode, String errorMessageId, String errorMessage, String systemAction, String userAction) {
        this.messageDefinition = new ExceptionMessageDefinition(httpErrorCode, errorMessageId, errorMessage, systemAction, userAction);
    }

    public ExceptionMessageDefinition getMessageDefinition() {
        return this.messageDefinition;
    }

    public ExceptionMessageDefinition getMessageDefinition(String ... params) {
        this.messageDefinition.setMessageParameters(params);
        return this.messageDefinition;
    }

    public String toString() {
        return "OMAGServerInstanceErrorCode{messageDefinition=" + this.messageDefinition + '}';
    }
}

