/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.multitenant;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.commonservices.multitenant.OMAGServerServiceInstance;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.OMAGServerInstanceErrorCode;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.platformservices.properties.OMAGServerInstanceHistory;

class OMAGServerInstance {
    private String serverName;
    private String serverType;
    private List<OMAGServerInstanceHistory> serverHistory = new ArrayList<OMAGServerInstanceHistory>();
    private Map<String, OMAGServerServiceInstance> serviceInstanceMap = new HashMap<String, OMAGServerServiceInstance>();
    private Date serverStartTime = new Date();
    private OpenMetadataServerSecurityVerifier securityVerifier = new OpenMetadataServerSecurityVerifier();

    OMAGServerInstance(String serverName) {
        this.serverName = serverName;
    }

    String getServerName() {
        return this.serverName;
    }

    void setServerType(String serverType) {
        this.serverType = serverType;
    }

    String getServerType() {
        return this.serverType;
    }

    void initialize() {
        this.serverStartTime = new Date();
    }

    synchronized List<String> getRegisteredServices() {
        Set<String> keySet = this.serviceInstanceMap.keySet();
        if (keySet.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(keySet);
    }

    synchronized Date getServerStartTime() {
        return this.serverStartTime;
    }

    synchronized Date getServerEndTime() {
        if (this.serverStartTime == null) {
            return this.serverHistory.get(this.serverHistory.size() - 1).getEndTime();
        }
        return null;
    }

    synchronized List<OMAGServerInstanceHistory> getServerHistory() {
        if (this.serverHistory.isEmpty()) {
            return null;
        }
        return new ArrayList<OMAGServerInstanceHistory>(this.serverHistory);
    }

    synchronized OpenMetadataServerSecurityVerifier registerSecurityValidator(String localServerUserId, AuditLog auditLog, Connection connection) throws org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException {
        try {
            this.securityVerifier.registerSecurityValidator(localServerUserId, this.serverName, auditLog, connection);
        }
        catch (InvalidParameterException error) {
            throw new org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException(error.getReportedErrorMessage(), error);
        }
        return this.securityVerifier;
    }

    synchronized OpenMetadataServerSecurityVerifier getSecurityVerifier() {
        return this.securityVerifier;
    }

    synchronized void registerService(String serviceName, OMAGServerServiceInstance serviceInstance) {
        if (serviceInstance != null) {
            this.serviceInstanceMap.put(serviceName, serviceInstance);
            serviceInstance.setSecurityVerifier(this.securityVerifier);
        }
    }

    synchronized OMAGServerServiceInstance getRegisteredService(String userId, String serviceName, String serviceOperationName) throws org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException, PropertyServerException {
        try {
            this.securityVerifier.validateUserForService(userId, serviceName);
            this.securityVerifier.validateUserForServiceOperation(userId, serviceName, serviceOperationName);
        }
        catch (UserNotAuthorizedException error) {
            throw new org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException(error);
        }
        OMAGServerServiceInstance serverServiceInstance = this.serviceInstanceMap.get(serviceName);
        if (serverServiceInstance == null) {
            throw new PropertyServerException(OMAGServerInstanceErrorCode.SERVICE_NOT_AVAILABLE.getMessageDefinition(serviceName, this.serverName, userId), this.getClass().getName(), serviceOperationName);
        }
        return serverServiceInstance;
    }

    synchronized void unRegisterService(String serviceName) {
        this.serviceInstanceMap.remove(serviceName);
    }

    synchronized void shutdown(String methodName) throws PropertyServerException {
        this.serverHistory.add(new OMAGServerInstanceHistory(this.serverStartTime, new Date()));
        this.serverStartTime = null;
        if (!this.serviceInstanceMap.isEmpty()) {
            this.serviceInstanceMap = new HashMap<String, OMAGServerServiceInstance>();
            throw new PropertyServerException(OMAGServerInstanceErrorCode.SERVICES_NOT_SHUTDOWN.getMessageDefinition(this.serverName, this.serviceInstanceMap.keySet().toString()), this.getClass().getName(), methodName);
        }
    }
}

