/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.multitenant;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.adminservices.configuration.OMAGAccessServiceRegistration;
import org.odpi.openmetadata.adminservices.configuration.OMAGViewServiceRegistration;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceRegistration;
import org.odpi.openmetadata.adminservices.configuration.registration.CommonServicesDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.EngineServiceRegistration;
import org.odpi.openmetadata.adminservices.configuration.registration.GovernanceServicesDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.ServiceOperationalStatus;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceRegistration;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGService;
import org.odpi.openmetadata.commonservices.multitenant.OMAGServerInstance;
import org.odpi.openmetadata.commonservices.multitenant.OMAGServerServiceInstance;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.OMAGServerInstanceErrorCode;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDevelopmentStatus;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.governanceservers.enginehostservices.registration.OMAGEngineServiceRegistration;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.registration.IntegrationServiceRegistry;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataPlatformSecurityVerifier;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.platformservices.properties.OMAGServerInstanceHistory;

public class OMAGServerPlatformInstanceMap {
    private static Map<String, OMAGServerInstance> activeServerInstanceMap = new HashMap<String, OMAGServerInstance>();
    private static Map<String, OMAGServerInstance> inActiveServerInstanceMap = new HashMap<String, OMAGServerInstance>();

    private static void validateUserAsInvestigatorForPlatform(String userId) throws org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException {
        try {
            OpenMetadataPlatformSecurityVerifier.validateUserAsInvestigatorForPlatform((String)userId);
        }
        catch (UserNotAuthorizedException error) {
            throw new org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException(error);
        }
    }

    private static RegisteredOMAGService getServiceDescription(int serviceId, String serviceName, ComponentDevelopmentStatus serviceDevelopmentStatus, String serviceURLMarker, String serviceDescription, String serviceWiki) {
        RegisteredOMAGService service = new RegisteredOMAGService();
        service.setServiceId(serviceId);
        service.setServiceName(serviceName);
        service.setServiceDevelopmentStatus(serviceDevelopmentStatus);
        service.setServiceURLMarker(serviceURLMarker);
        service.setServiceDescription(serviceDescription);
        service.setServiceWiki(serviceWiki);
        return service;
    }

    public List<RegisteredOMAGService> getRegisteredAccessServices(String userId) throws org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException {
        OMAGServerPlatformInstanceMap.validateUserAsInvestigatorForPlatform(userId);
        ArrayList<RegisteredOMAGService> response = new ArrayList<RegisteredOMAGService>();
        List accessServiceRegistrationList = OMAGAccessServiceRegistration.getAccessServiceRegistrationList();
        if (accessServiceRegistrationList != null && !accessServiceRegistrationList.isEmpty()) {
            for (AccessServiceRegistration registration : accessServiceRegistrationList) {
                if (registration == null || registration.getAccessServiceOperationalStatus() != ServiceOperationalStatus.ENABLED) continue;
                response.add(OMAGServerPlatformInstanceMap.getServiceDescription(registration.getAccessServiceCode(), registration.getAccessServiceFullName(), registration.getAccessServiceDevelopmentStatus(), registration.getAccessServiceURLMarker(), registration.getAccessServiceDescription(), registration.getAccessServiceWiki()));
            }
        }
        if (response.isEmpty()) {
            return null;
        }
        return response;
    }

    public List<RegisteredOMAGService> getRegisteredEngineServices(String userId) throws org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException {
        OMAGServerPlatformInstanceMap.validateUserAsInvestigatorForPlatform(userId);
        ArrayList<RegisteredOMAGService> response = new ArrayList<RegisteredOMAGService>();
        List engineServiceRegistrationList = OMAGEngineServiceRegistration.getEngineServiceRegistrationList();
        if (engineServiceRegistrationList != null && !engineServiceRegistrationList.isEmpty()) {
            for (EngineServiceRegistration registration : engineServiceRegistrationList) {
                if (registration == null || registration.getEngineServiceOperationalStatus() != ServiceOperationalStatus.ENABLED) continue;
                response.add(OMAGServerPlatformInstanceMap.getServiceDescription(registration.getEngineServiceId(), registration.getEngineServiceFullName(), registration.getEngineServiceDevelopmentStatus(), registration.getEngineServiceURLMarker(), registration.getEngineServiceDescription(), registration.getEngineServiceWiki()));
            }
        }
        if (response.isEmpty()) {
            return null;
        }
        return response;
    }

    public List<RegisteredOMAGService> getRegisteredIntegrationServices(String userId) throws org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException {
        OMAGServerPlatformInstanceMap.validateUserAsInvestigatorForPlatform(userId);
        return IntegrationServiceRegistry.getRegisteredIntegrationServices();
    }

    public List<RegisteredOMAGService> getRegisteredViewServices(String userId) throws org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException {
        OMAGServerPlatformInstanceMap.validateUserAsInvestigatorForPlatform(userId);
        ArrayList<RegisteredOMAGService> response = new ArrayList<RegisteredOMAGService>();
        List viewServiceRegistrationList = OMAGViewServiceRegistration.getViewServiceRegistrationList();
        if (viewServiceRegistrationList != null && !viewServiceRegistrationList.isEmpty()) {
            for (ViewServiceRegistration registration : viewServiceRegistrationList) {
                if (registration == null || registration.getViewServiceOperationalStatus() != ServiceOperationalStatus.ENABLED) continue;
                response.add(OMAGServerPlatformInstanceMap.getServiceDescription(registration.getViewServiceCode(), registration.getViewServiceFullName(), registration.getViewServiceDevelopmentStatus(), registration.getViewServiceURLMarker(), registration.getViewServiceDescription(), registration.getViewServiceWiki()));
            }
        }
        if (response.isEmpty()) {
            return null;
        }
        return response;
    }

    public List<RegisteredOMAGService> getRegisteredGovernanceServices(String userId) throws org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException {
        OMAGServerPlatformInstanceMap.validateUserAsInvestigatorForPlatform(userId);
        ArrayList<RegisteredOMAGService> response = new ArrayList<RegisteredOMAGService>();
        GovernanceServicesDescription[] governanceServicesDescriptions = GovernanceServicesDescription.values();
        if (governanceServicesDescriptions.length != 0) {
            for (GovernanceServicesDescription registration : governanceServicesDescriptions) {
                if (registration == null) continue;
                response.add(OMAGServerPlatformInstanceMap.getServiceDescription(registration.getServiceCode(), registration.getServiceName(), registration.getServiceDevelopmentStatus(), registration.getServiceURLMarker(), registration.getServiceDescription(), registration.getServiceWiki()));
            }
        }
        if (response.isEmpty()) {
            return null;
        }
        return response;
    }

    public List<RegisteredOMAGService> getRegisteredCommonServices(String userId) throws org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException {
        OMAGServerPlatformInstanceMap.validateUserAsInvestigatorForPlatform(userId);
        ArrayList<RegisteredOMAGService> response = new ArrayList<RegisteredOMAGService>();
        CommonServicesDescription[] commonServicesDescriptions = CommonServicesDescription.values();
        if (commonServicesDescriptions.length != 0) {
            for (CommonServicesDescription registration : commonServicesDescriptions) {
                if (registration == null) continue;
                response.add(OMAGServerPlatformInstanceMap.getServiceDescription(registration.getServiceCode(), registration.getServiceName(), registration.getServiceDevelopmentStatus(), registration.getServiceURLMarker(), registration.getServiceDescription(), registration.getServiceWiki()));
            }
        }
        if (response.isEmpty()) {
            return null;
        }
        return response;
    }

    public List<RegisteredOMAGService> getAllRegisteredServices(String userId) throws org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException {
        ArrayList<RegisteredOMAGService> response = new ArrayList<RegisteredOMAGService>();
        List<RegisteredOMAGService> services = this.getRegisteredCommonServices(userId);
        if (services != null && !services.isEmpty()) {
            response.addAll(services);
        }
        if ((services = this.getRegisteredAccessServices(userId)) != null && !services.isEmpty()) {
            response.addAll(services);
        }
        if ((services = this.getRegisteredIntegrationServices(userId)) != null && !services.isEmpty()) {
            response.addAll(services);
        }
        if ((services = this.getRegisteredViewServices(userId)) != null && !services.isEmpty()) {
            response.addAll(services);
        }
        if ((services = this.getRegisteredGovernanceServices(userId)) != null && !services.isEmpty()) {
            response.addAll(services);
        }
        return response;
    }

    private static synchronized OMAGServerInstance getActiveServerInstance(String serverName) {
        OMAGServerInstance serverInstance = activeServerInstanceMap.get(serverName);
        if (serverInstance == null) {
            serverInstance = inActiveServerInstanceMap.get(serverName);
            if (serverInstance == null) {
                serverInstance = new OMAGServerInstance(serverName);
                activeServerInstanceMap.put(serverName, serverInstance);
            } else {
                activeServerInstanceMap.put(serverName, serverInstance);
                inActiveServerInstanceMap.remove(serverName);
            }
        }
        return serverInstance;
    }

    private static synchronized void setInstanceForPlatform(String serverName, String serverType, String serviceName, OMAGServerServiceInstance instance) {
        OMAGServerInstance serverInstance = OMAGServerPlatformInstanceMap.getActiveServerInstance(serverName);
        serverInstance.registerService(serviceName, instance);
        if (serverType != null) {
            serverInstance.setServerType(serverType);
        }
    }

    private static synchronized OpenMetadataServerSecurityVerifier setServerActiveWithSecurity(String localServerUserId, String serverName, AuditLog auditLog, Connection connection) throws InvalidParameterException {
        OMAGServerInstance serverInstance = OMAGServerPlatformInstanceMap.getActiveServerInstance(serverName);
        serverInstance.initialize();
        return serverInstance.registerSecurityValidator(localServerUserId, auditLog, connection);
    }

    private static synchronized String getServerInstanceType(String userId, String serverName, String serviceOperationName) throws InvalidParameterException, org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException {
        OMAGServerPlatformInstanceMap.validateUserAsInvestigatorForPlatform(userId);
        OMAGServerInstance serverInstance = activeServerInstanceMap.get(serverName);
        if (serverInstance != null) {
            return serverInstance.getServerType();
        }
        OMAGServerPlatformInstanceMap.handleBadServerName(userId, serverName, serviceOperationName);
        return null;
    }

    private static synchronized boolean isServerInstanceActive(String userId, String serverName) throws org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException {
        OMAGServerPlatformInstanceMap.validateUserAsInvestigatorForPlatform(userId);
        return activeServerInstanceMap.get(serverName) != null;
    }

    private static synchronized boolean isServerInstanceKnown(String userId, String serverName) throws org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException {
        OMAGServerPlatformInstanceMap.validateUserAsInvestigatorForPlatform(userId);
        return activeServerInstanceMap.get(serverName) != null || inActiveServerInstanceMap.get(serverName) != null;
    }

    private static synchronized OMAGServerServiceInstance getInstanceForPlatform(String userId, String serverName, String serviceName, String serviceOperationName) throws InvalidParameterException, org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException, PropertyServerException {
        OMAGServerInstance serverInstance = activeServerInstanceMap.get(serverName);
        if (serverInstance != null) {
            OpenMetadataServerSecurityVerifier serverSecurityVerifier = serverInstance.getSecurityVerifier();
            try {
                serverSecurityVerifier.validateUserForServer(userId);
                serverSecurityVerifier.validateUserForService(userId, serviceName);
                serverSecurityVerifier.validateUserForServiceOperation(userId, serviceName, serviceOperationName);
            }
            catch (UserNotAuthorizedException error) {
                throw new org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException(error);
            }
            return serverInstance.getRegisteredService(userId, serviceName, serviceOperationName);
        }
        OMAGServerPlatformInstanceMap.handleBadServerName(userId, serverName, serviceOperationName);
        return null;
    }

    private static synchronized List<String> getActiveServerListForPlatform(String userId) throws org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException {
        try {
            OpenMetadataPlatformSecurityVerifier.validateUserAsInvestigatorForPlatform((String)userId);
        }
        catch (UserNotAuthorizedException error) {
            throw new org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException(error);
        }
        Set<String> activeServerSet = activeServerInstanceMap.keySet();
        if (activeServerSet.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(activeServerSet);
    }

    private static synchronized List<String> getKnownServerListForPlatform(String userId) throws org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException {
        try {
            OpenMetadataPlatformSecurityVerifier.validateUserAsInvestigatorForPlatform((String)userId);
        }
        catch (UserNotAuthorizedException error) {
            throw new org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException(error);
        }
        ArrayList<String> knownServerList = new ArrayList<String>(activeServerInstanceMap.keySet());
        knownServerList.addAll(inActiveServerInstanceMap.keySet());
        if (knownServerList.isEmpty()) {
            return null;
        }
        return knownServerList;
    }

    private static synchronized void validateUserAsServerInvestigator(String userId, OMAGServerInstance serverInstance) throws org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException {
        if (serverInstance != null) {
            OpenMetadataServerSecurityVerifier serverSecurityVerifier = serverInstance.getSecurityVerifier();
            try {
                serverSecurityVerifier.validateUserForServer(userId);
                serverSecurityVerifier.validateUserAsServerInvestigator(userId);
            }
            catch (UserNotAuthorizedException error) {
                throw new org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException(error);
            }
        }
    }

    private static synchronized Date getServerStartTimeFromPlatform(String userId, String serverName) throws InvalidParameterException, org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "getServerStartTimeFromPlatform";
        OMAGServerInstance serverInstance = activeServerInstanceMap.get(serverName);
        if (serverInstance == null) {
            serverInstance = inActiveServerInstanceMap.get(serverName);
        }
        if (serverInstance != null) {
            OMAGServerPlatformInstanceMap.validateUserAsServerInvestigator(userId, serverInstance);
            return serverInstance.getServerStartTime();
        }
        OMAGServerPlatformInstanceMap.handleBadServerName(userId, serverName, "getServerStartTimeFromPlatform");
        return null;
    }

    private static synchronized Date getServerEndTimeFromPlatform(String userId, String serverName) throws InvalidParameterException, org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "getServerEndTimeFromPlatform";
        OMAGServerInstance serverInstance = activeServerInstanceMap.get(serverName);
        if (serverInstance == null) {
            serverInstance = inActiveServerInstanceMap.get(serverName);
        }
        if (serverInstance != null) {
            OMAGServerPlatformInstanceMap.validateUserAsServerInvestigator(userId, serverInstance);
            return serverInstance.getServerEndTime();
        }
        OMAGServerPlatformInstanceMap.handleBadServerName(userId, serverName, "getServerEndTimeFromPlatform");
        return null;
    }

    private static synchronized List<OMAGServerInstanceHistory> getServerHistoryFromPlatform(String userId, String serverName) throws InvalidParameterException, org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "getServerHistoryFromPlatform";
        OMAGServerInstance serverInstance = activeServerInstanceMap.get(serverName);
        if (serverInstance == null) {
            serverInstance = inActiveServerInstanceMap.get(serverName);
        }
        if (serverInstance != null) {
            OMAGServerPlatformInstanceMap.validateUserAsServerInvestigator(userId, serverInstance);
            return serverInstance.getServerHistory();
        }
        OMAGServerPlatformInstanceMap.handleBadServerName(userId, serverName, "getServerHistoryFromPlatform");
        return null;
    }

    private static synchronized List<String> getActiveServiceListForServerOnPlatform(String userId, String serverName) throws InvalidParameterException, org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "getActiveServiceListForServerOnPlatform";
        OMAGServerInstance serverInstance = activeServerInstanceMap.get(serverName);
        if (serverInstance != null) {
            OMAGServerPlatformInstanceMap.validateUserAsServerInvestigator(userId, serverInstance);
            return serverInstance.getRegisteredServices();
        }
        serverInstance = inActiveServerInstanceMap.get(serverName);
        if (serverInstance != null) {
            OMAGServerPlatformInstanceMap.validateUserAsServerInvestigator(userId, serverInstance);
        } else {
            OMAGServerPlatformInstanceMap.handleBadServerName(userId, serverName, "getActiveServiceListForServerOnPlatform");
        }
        return null;
    }

    private static synchronized void removeInstanceForPlatform(String serverName, String serviceName) {
        OMAGServerInstance serverInstance = activeServerInstanceMap.get(serverName);
        if (serverInstance != null) {
            serverInstance.unRegisterService(serviceName);
        }
    }

    private static synchronized void setServerInActive(String userId, String serverName, String methodName) throws InvalidParameterException, PropertyServerException {
        OMAGServerInstance serverInstance = activeServerInstanceMap.get(serverName);
        if (serverInstance == null) {
            OMAGServerPlatformInstanceMap.handleBadServerName(userId, serverName, methodName);
        } else {
            try {
                serverInstance.shutdown(methodName);
            }
            catch (Exception error) {
                throw error;
            }
            finally {
                inActiveServerInstanceMap.put(serverName, serverInstance);
                activeServerInstanceMap.remove(serverName);
            }
        }
    }

    private static synchronized OpenMetadataServerSecurityVerifier getServerSecurityVerifierForPlatform(String userId, String serverName) throws InvalidParameterException {
        String methodName = "getServerSecurityVerifierForPlatform";
        OMAGServerInstance serverInstance = activeServerInstanceMap.get(serverName);
        if (serverInstance != null) {
            return serverInstance.getSecurityVerifier();
        }
        OMAGServerPlatformInstanceMap.handleBadServerName(userId, serverName, "getServerSecurityVerifierForPlatform");
        return null;
    }

    private static void handleBadServerName(String userId, String serverName, String methodName) throws InvalidParameterException {
        HashMap<String, String> debugProperties = new HashMap<String, String>();
        String serverNameProperty = "serverName";
        debugProperties.put("serverName", serverName);
        throw new InvalidParameterException(OMAGServerInstanceErrorCode.SERVER_NOT_AVAILABLE.getMessageDefinition(serverName, userId), OMAGServerPlatformInstanceMap.class.getName(), methodName, "serverName", debugProperties);
    }

    public String getServerType(String userId, String serverName, String serviceOperationName) throws InvalidParameterException, org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException {
        return OMAGServerPlatformInstanceMap.getServerInstanceType(userId, serverName, serviceOperationName);
    }

    public boolean isServerActive(String userId, String serverName) throws org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException {
        return OMAGServerPlatformInstanceMap.isServerInstanceActive(userId, serverName);
    }

    public boolean isServerKnown(String userId, String serverName) throws org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException {
        return OMAGServerPlatformInstanceMap.isServerInstanceKnown(userId, serverName);
    }

    public Date getServerStartTime(String userId, String serverName) throws InvalidParameterException, org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException {
        return OMAGServerPlatformInstanceMap.getServerStartTimeFromPlatform(userId, serverName);
    }

    public Date getServerEndTime(String userId, String serverName) throws InvalidParameterException, org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException {
        return OMAGServerPlatformInstanceMap.getServerEndTimeFromPlatform(userId, serverName);
    }

    public List<OMAGServerInstanceHistory> getServerHistory(String userId, String serverName) throws InvalidParameterException, org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException {
        return OMAGServerPlatformInstanceMap.getServerHistoryFromPlatform(userId, serverName);
    }

    void addServiceInstanceToPlatform(String serverName, String serverType, String serviceName, OMAGServerServiceInstance instance) {
        OMAGServerPlatformInstanceMap.setInstanceForPlatform(serverName, serverType, serviceName, instance);
    }

    public OpenMetadataServerSecurityVerifier startUpServerInstance(String localServerUserId, String serverName, AuditLog auditLog, Connection connection) throws InvalidParameterException {
        return OMAGServerPlatformInstanceMap.setServerActiveWithSecurity(localServerUserId, serverName, auditLog, connection);
    }

    public void shutdownServerInstance(String userId, String serverName, String methodName) throws InvalidParameterException, PropertyServerException {
        OMAGServerPlatformInstanceMap.setServerInActive(userId, serverName, methodName);
    }

    OMAGServerServiceInstance getServiceInstance(String userId, String serverName, String serviceName, String serviceOperationName) throws InvalidParameterException, org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException, PropertyServerException {
        return OMAGServerPlatformInstanceMap.getInstanceForPlatform(userId, serverName, serviceName, serviceOperationName);
    }

    void removeServiceInstanceFromPlatform(String serverName, String serviceName) {
        OMAGServerPlatformInstanceMap.removeInstanceForPlatform(serverName, serviceName);
    }

    OpenMetadataServerSecurityVerifier getServerSecurityVerifier(String userId, String serverName) throws InvalidParameterException {
        return OMAGServerPlatformInstanceMap.getServerSecurityVerifierForPlatform(userId, serverName);
    }

    public List<String> getActiveServerList(String userId) throws org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException {
        return OMAGServerPlatformInstanceMap.getActiveServerListForPlatform(userId);
    }

    public List<String> getKnownServerList(String userId) throws org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException {
        return OMAGServerPlatformInstanceMap.getKnownServerListForPlatform(userId);
    }

    public List<String> getActiveServiceListForServer(String userId, String serverName) throws InvalidParameterException, org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException {
        return OMAGServerPlatformInstanceMap.getActiveServiceListForServerOnPlatform(userId, serverName);
    }
}

