/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.multitenant;

import java.util.List;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.commonservices.multitenant.AuditableServerServiceInstanceHandler;
import org.odpi.openmetadata.commonservices.multitenant.OMASServiceInstance;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryErrorHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class OMASServiceInstanceHandler
extends AuditableServerServiceInstanceHandler {
    private RESTExceptionHandler exceptionHandler = new RESTExceptionHandler();

    public OMASServiceInstanceHandler(String serviceName) {
        super(serviceName);
    }

    public OMRSRepositoryConnector getRepositoryConnector(String userId, String serverName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        OMASServiceInstance instance = (OMASServiceInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        return instance.getRepositoryConnector();
    }

    public OMRSRepositoryHelper getRepositoryHelper(String userId, String serverName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        OMASServiceInstance instance = (OMASServiceInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        return instance.getRepositoryHelper();
    }

    public OMRSMetadataCollection getMetadataCollection(String userId, String serverName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        OMASServiceInstance instance = (OMASServiceInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        return instance.getMetadataCollection();
    }

    public RepositoryHandler getRepositoryHandler(String userId, String serverName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        OMASServiceInstance instance = (OMASServiceInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        return instance.getRepositoryHandler();
    }

    public RepositoryErrorHandler getErrorHandler(String userId, String serverName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        OMASServiceInstance instance = (OMASServiceInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        return instance.getErrorHandler();
    }

    public String getServiceName(String callingServiceURLName) {
        String assetOwnerURLName = "asset-owner";
        String assetConsumerURLName = "asset-consumer";
        String discoveryEngineURLName = "discovery-engine";
        String callingServiceName = "asset-owner".equals(callingServiceURLName) ? AccessServiceDescription.ASSET_OWNER_OMAS.getAccessServiceFullName() : ("asset-consumer".equals(callingServiceURLName) ? AccessServiceDescription.ASSET_CONSUMER_OMAS.getAccessServiceFullName() : ("discovery-engine".equals(callingServiceURLName) ? AccessServiceDescription.DISCOVERY_ENGINE_OMAS.getAccessServiceFullName() : callingServiceURLName));
        return callingServiceName;
    }

    private OMASServiceInstance getCallingServiceInstance(String userId, String serverName, String callingServiceURLName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return (OMASServiceInstance)this.platformInstanceMap.getServiceInstance(userId, serverName, this.getServiceName(callingServiceURLName), serviceOperationName);
    }

    public List<String> getSupportedZones(String userId, String serverName, String callingServiceURLName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        OMASServiceInstance callingServiceInstance = this.getCallingServiceInstance(userId, serverName, callingServiceURLName, serviceOperationName);
        if (callingServiceInstance != null) {
            return callingServiceInstance.getSupportedZones();
        }
        return null;
    }

    public List<String> getDefaultZones(String userId, String serverName, String callingServiceURLName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        OMASServiceInstance callingServiceInstance = this.getCallingServiceInstance(userId, serverName, callingServiceURLName, serviceOperationName);
        if (callingServiceInstance != null) {
            return callingServiceInstance.getDefaultZones();
        }
        return null;
    }

    public List<String> getPublishZones(String userId, String serverName, String callingServiceURLName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        OMASServiceInstance callingServiceInstance = this.getCallingServiceInstance(userId, serverName, callingServiceURLName, serviceOperationName);
        if (callingServiceInstance != null) {
            return callingServiceInstance.getPublishZones();
        }
        return null;
    }

    public List<String> getSupportedZones(String userId, String serverName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        OMASServiceInstance instance = (OMASServiceInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        return instance.getSupportedZones();
    }

    public List<String> getDefaultZones(String userId, String serverName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        OMASServiceInstance instance = (OMASServiceInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        return instance.getDefaultZones();
    }

    public List<String> getPublishZones(String userId, String serverName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        OMASServiceInstance instance = (OMASServiceInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        return instance.getPublishZones();
    }

    public Connection getInTopicConnection(String userId, String serverName, String serviceOperationName, String callerId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        OMASServiceInstance instance = (OMASServiceInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        if (instance != null) {
            return instance.getInTopicClientConnection(callerId);
        }
        return null;
    }

    public Connection getOutTopicConnection(String userId, String serverName, String serviceOperationName, String callerId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        OMASServiceInstance instance = (OMASServiceInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        if (instance != null) {
            return instance.getOutTopicClientConnection(callerId);
        }
        return null;
    }

    public RESTExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }
}

