/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.multitenant;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.properties.ConnectorReport;
import org.odpi.openmetadata.commonservices.multitenant.AuditableServerServiceInstanceHandler;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.OMAGServerInstanceErrorCode;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorProvider;
import org.odpi.openmetadata.frameworks.connectors.ConnectorProviderBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.governanceaction.GovernanceActionServiceProviderBase;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.connectors.IntegrationConnectorProvider;

public class GovernanceServerServiceInstanceHandler
extends AuditableServerServiceInstanceHandler {
    protected final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();

    public GovernanceServerServiceInstanceHandler(String serviceName) {
        super(serviceName);
    }

    public ConnectorReport validateConnector(String connectorProviderClassName, Class<?> requiredConnectorInterface, String serviceName) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        String providerClassNameParameterName = "connectorProviderClassName";
        String requiredConnectorInterfaceParameterName = "requiredConnectorInterface";
        String testConnectionQualifiedName = "testConnection";
        String methodName = "validateConnector";
        this.invalidParameterHandler.validateName(connectorProviderClassName, "connectorProviderClassName", "validateConnector");
        this.invalidParameterHandler.validateObject(requiredConnectorInterface, "requiredConnectorInterface", "validateConnector");
        Class<?> connectorProviderClass = Class.forName(connectorProviderClassName);
        Object potentialConnectorProvider = connectorProviderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        ConnectorProvider connectorProvider = (ConnectorProvider)potentialConnectorProvider;
        ConnectorType connectorType = connectorProvider.getConnectorType();
        if (connectorType == null) {
            connectorType = new ConnectorType();
            connectorType.setConnectorProviderClassName(connectorProviderClassName);
        }
        Connection testConnection = new Connection();
        testConnection.setQualifiedName("testConnection");
        testConnection.setConnectorType(connectorType);
        Connector connector = connectorProvider.getConnector(testConnection);
        if (!requiredConnectorInterface.isInstance(connector)) {
            throw new InvalidParameterException(OMAGServerInstanceErrorCode.NOT_CORRECT_CONNECTOR_PROVIDER.getMessageDefinition(connectorProviderClassName, requiredConnectorInterface.getCanonicalName(), serviceName), this.getClass().getName(), "validateConnector", connectorProviderClassName);
        }
        ConnectorReport connectorReport = new ConnectorReport();
        connectorReport.setConnectorType(connectorType);
        if (connectorProvider instanceof ConnectorProviderBase) {
            ConnectorProviderBase connectorProviderBase = (ConnectorProviderBase)connectorProvider;
            connectorReport.setComponentDescription(connectorProviderBase.getConnectorComponentDescription());
        }
        if (connectorProvider instanceof IntegrationConnectorProvider) {
            IntegrationConnectorProvider integrationConnectorProvider = (IntegrationConnectorProvider)connectorProvider;
            connectorReport.setRefreshTimeInterval(integrationConnectorProvider.getRefreshTimeInterval());
            connectorReport.setUsesBlockingCalls(integrationConnectorProvider.getUsesBlockingCalls());
        }
        if (connectorProvider instanceof GovernanceActionServiceProviderBase) {
            GovernanceActionServiceProviderBase governanceActionServiceProvider = (GovernanceActionServiceProviderBase)connectorProvider;
            connectorReport.setSupportedRequestTypes(governanceActionServiceProvider.supportedRequestTypes());
            connectorReport.setSupportedRequestParameters(governanceActionServiceProvider.supportedRequestParameters());
            connectorReport.setSupportedRequestSourceNames(governanceActionServiceProvider.supportedRequestSourceNames());
            connectorReport.setSupportedActionTargetNames(governanceActionServiceProvider.supportedActionTargetNames());
            connectorReport.setSupportedGuards(governanceActionServiceProvider.supportedGuards());
        }
        connector.disconnect();
        return connectorReport;
    }
}

