/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.multitenant;

import org.odpi.openmetadata.commonservices.multitenant.OMAGServerPlatformInstanceMap;
import org.odpi.openmetadata.commonservices.multitenant.OMAGServerServiceInstance;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;

public abstract class OMAGServerServiceInstanceHandler {
    protected OMAGServerPlatformInstanceMap platformInstanceMap = new OMAGServerPlatformInstanceMap();
    protected String serviceName;

    public OMAGServerServiceInstanceHandler(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public boolean isServerActive(String userId, String serverName) throws UserNotAuthorizedException {
        return this.platformInstanceMap.isServerActive(userId, serverName);
    }

    public OpenMetadataServerSecurityVerifier getServerSecurityVerifier(String userId, String serverName) throws InvalidParameterException {
        return this.platformInstanceMap.getServerSecurityVerifier(userId, serverName);
    }

    protected OMAGServerServiceInstance getServerServiceInstance(String userId, String serverName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.platformInstanceMap.getServiceInstance(userId, serverName, this.serviceName, serviceOperationName);
    }

    public void removeServerServiceInstance(String serverName) {
        this.platformInstanceMap.removeServiceInstanceFromPlatform(serverName, this.serviceName);
    }
}

