/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.multitenant;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceRegistrationEntry;
import org.odpi.openmetadata.adminservices.registration.OMAGAccessServiceRegistration;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.multitenant.AuditableServerServiceInstanceHandler;
import org.odpi.openmetadata.commonservices.multitenant.OMASServiceInstance;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryErrorHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class OMASServiceInstanceHandler
extends AuditableServerServiceInstanceHandler {
    private final RESTExceptionHandler exceptionHandler = new RESTExceptionHandler();
    private Map<String, String> accessServiceLookupTable = null;

    public OMASServiceInstanceHandler(String serviceName) {
        super(serviceName);
    }

    public OMRSRepositoryConnector getRepositoryConnector(String userId, String serverName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        OMASServiceInstance instance = (OMASServiceInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        return instance.getRepositoryConnector();
    }

    public OMRSRepositoryHelper getRepositoryHelper(String userId, String serverName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        OMASServiceInstance instance = (OMASServiceInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        return instance.getRepositoryHelper();
    }

    public OMRSMetadataCollection getMetadataCollection(String userId, String serverName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        OMASServiceInstance instance = (OMASServiceInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        return instance.getMetadataCollection();
    }

    public RepositoryHandler getRepositoryHandler(String userId, String serverName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        OMASServiceInstance instance = (OMASServiceInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        return instance.getRepositoryHandler();
    }

    public RepositoryErrorHandler getErrorHandler(String userId, String serverName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        OMASServiceInstance instance = (OMASServiceInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        return instance.getErrorHandler();
    }

    public String getServiceName(String callingServiceURLName) {
        if (this.accessServiceLookupTable == null) {
            this.accessServiceLookupTable = new HashMap<String, String>();
            List accessServiceRegistrationList = OMAGAccessServiceRegistration.getAccessServiceRegistrationList();
            for (AccessServiceRegistrationEntry registration : accessServiceRegistrationList) {
                this.accessServiceLookupTable.put(registration.getAccessServiceURLMarker(), registration.getAccessServiceFullName());
            }
        }
        if (this.accessServiceLookupTable.get(callingServiceURLName) != null) {
            return this.accessServiceLookupTable.get(callingServiceURLName);
        }
        return callingServiceURLName;
    }

    private OMASServiceInstance getCallingServiceInstance(String userId, String serverName, String callingServiceURLName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return (OMASServiceInstance)this.platformInstanceMap.getServiceInstance(userId, serverName, this.getServiceName(callingServiceURLName), serviceOperationName);
    }

    public List<String> getSupportedZones(String userId, String serverName, String callingServiceURLName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        OMASServiceInstance callingServiceInstance = this.getCallingServiceInstance(userId, serverName, callingServiceURLName, serviceOperationName);
        if (callingServiceInstance != null) {
            return callingServiceInstance.getSupportedZones();
        }
        return null;
    }

    public List<String> getDefaultZones(String userId, String serverName, String callingServiceURLName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        OMASServiceInstance callingServiceInstance = this.getCallingServiceInstance(userId, serverName, callingServiceURLName, serviceOperationName);
        if (callingServiceInstance != null) {
            return callingServiceInstance.getDefaultZones();
        }
        return null;
    }

    public List<String> getPublishZones(String userId, String serverName, String callingServiceURLName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        OMASServiceInstance callingServiceInstance = this.getCallingServiceInstance(userId, serverName, callingServiceURLName, serviceOperationName);
        if (callingServiceInstance != null) {
            return callingServiceInstance.getPublishZones();
        }
        return null;
    }

    public List<String> getSupportedZones(String userId, String serverName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        OMASServiceInstance instance = (OMASServiceInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        return instance.getSupportedZones();
    }

    public List<String> getDefaultZones(String userId, String serverName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        OMASServiceInstance instance = (OMASServiceInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        return instance.getDefaultZones();
    }

    public List<String> getPublishZones(String userId, String serverName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        OMASServiceInstance instance = (OMASServiceInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        return instance.getPublishZones();
    }

    public Connection getInTopicConnection(String userId, String serverName, String serviceOperationName, String callerId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        OMASServiceInstance instance = (OMASServiceInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        if (instance != null) {
            return instance.getInTopicClientConnection(callerId);
        }
        return null;
    }

    public Connection getOutTopicConnection(String userId, String serverName, String serviceOperationName, String callerId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        OMASServiceInstance instance = (OMASServiceInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        if (instance != null) {
            return instance.getOutTopicClientConnection(callerId);
        }
        return null;
    }

    public RESTExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }
}

