/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.multitenant;

import java.util.regex.Pattern;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.multitenant.AuditableServerServiceInstanceHandler;

public class OMVSServiceInstanceHandler
extends AuditableServerServiceInstanceHandler {
    private final RESTExceptionHandler exceptionHandler = new RESTExceptionHandler();

    public OMVSServiceInstanceHandler(String serviceName) {
        super(serviceName);
    }

    public RESTExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    private String setInsensitive(String searchString, boolean insensitive) {
        return insensitive ? "(?i)" + searchString : searchString;
    }

    public String getMiddleRegex(String searchString, boolean insensitive) {
        return searchString == null ? null : this.setInsensitive(".*" + this.getExactMatchRegex(searchString, false) + ".*", insensitive);
    }

    public String getStartsWithRegex(String searchString, boolean insensitive) {
        return searchString == null ? null : this.setInsensitive(this.getExactMatchRegex(searchString, false) + ".*", insensitive);
    }

    public String getEndsWithRegex(String searchString, boolean insensitive) {
        return searchString == null ? null : this.setInsensitive(".*" + this.getExactMatchRegex(searchString, false), insensitive);
    }

    String getExactMatchRegex(String searchString, boolean insensitive) {
        return searchString == null ? null : this.setInsensitive(Pattern.quote(searchString), insensitive);
    }

    public String getSearchString(String requestedSearch, boolean startsWith, boolean endsWith, boolean ignoreCase) {
        requestedSearch = requestedSearch == null || requestedSearch.isBlank() ? ".*" : (startsWith && endsWith ? this.getExactMatchRegex(requestedSearch, ignoreCase) : (startsWith ? this.getStartsWithRegex(requestedSearch, ignoreCase) : (endsWith ? this.getEndsWithRegex(requestedSearch, ignoreCase) : this.getMiddleRegex(requestedSearch, ignoreCase))));
        return requestedSearch;
    }
}

