/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.multitenant;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceRegistrationEntry;
import org.odpi.openmetadata.adminservices.configuration.registration.CommonServicesDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.EngineServiceRegistrationEntry;
import org.odpi.openmetadata.adminservices.configuration.registration.GovernanceServicesDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.ServerTypeClassification;
import org.odpi.openmetadata.adminservices.configuration.registration.ServiceOperationalStatus;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceRegistrationEntry;
import org.odpi.openmetadata.adminservices.registration.OMAGAccessServiceRegistration;
import org.odpi.openmetadata.adminservices.registration.OMAGViewServiceRegistration;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGService;
import org.odpi.openmetadata.commonservices.multitenant.OMAGServerInstance;
import org.odpi.openmetadata.commonservices.multitenant.OMAGServerServiceInstance;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.OMAGServerInstanceErrorCode;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDevelopmentStatus;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.governanceservers.enginehostservices.registration.OMAGEngineServiceRegistration;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.registration.IntegrationServiceRegistry;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataPlatformSecurityVerifier;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.serveroperations.properties.OMAGServerInstanceHistory;
import org.odpi.openmetadata.serveroperations.properties.ServerStatus;

public class OMAGServerPlatformInstanceMap {
    private static final Map<String, OMAGServerInstance> activeServerInstanceMap = new HashMap<String, OMAGServerInstance>();
    private static final Map<String, OMAGServerInstance> inActiveServerInstanceMap = new HashMap<String, OMAGServerInstance>();

    public static void validateUserAsInvestigatorForPlatform(String userId) throws UserNotAuthorizedException {
        try {
            OpenMetadataPlatformSecurityVerifier.validateUserAsInvestigatorForPlatform((String)userId);
        }
        catch (UserNotAuthorizedException error) {
            throw new UserNotAuthorizedException(error);
        }
    }

    public static synchronized void validateUserAsOperatorForPlatform(String userId) throws UserNotAuthorizedException {
        try {
            OpenMetadataPlatformSecurityVerifier.validateUserAsOperatorForPlatform((String)userId);
        }
        catch (UserNotAuthorizedException error) {
            throw new UserNotAuthorizedException(error);
        }
    }

    private static RegisteredOMAGService getServiceDescription(int serviceId, String serviceName, ComponentDevelopmentStatus serviceDevelopmentStatus, String serviceURLMarker, String serviceDescription, String serviceWiki, String serverType, String partnerServiceName, String partnerServerType) {
        RegisteredOMAGService service = new RegisteredOMAGService();
        service.setServiceId(serviceId);
        service.setServiceName(serviceName);
        service.setServiceDevelopmentStatus(serviceDevelopmentStatus);
        service.setServiceURLMarker(serviceURLMarker);
        service.setServiceDescription(serviceDescription);
        service.setServiceWiki(serviceWiki);
        service.setServerType(serverType);
        service.setPartnerServiceName(partnerServiceName);
        service.setPartnerServerType(partnerServerType);
        return service;
    }

    public List<RegisteredOMAGService> getRegisteredAccessServices(String userId) throws UserNotAuthorizedException {
        OMAGServerPlatformInstanceMap.validateUserAsInvestigatorForPlatform(userId);
        ArrayList<RegisteredOMAGService> response = new ArrayList<RegisteredOMAGService>();
        List accessServiceRegistrationList = OMAGAccessServiceRegistration.getAccessServiceRegistrationList();
        if (!accessServiceRegistrationList.isEmpty()) {
            for (AccessServiceRegistrationEntry registration : accessServiceRegistrationList) {
                if (registration == null || registration.getAccessServiceOperationalStatus() != ServiceOperationalStatus.ENABLED) continue;
                response.add(OMAGServerPlatformInstanceMap.getServiceDescription(registration.getAccessServiceCode(), registration.getAccessServiceFullName(), registration.getAccessServiceDevelopmentStatus(), registration.getAccessServiceURLMarker(), registration.getAccessServiceDescription(), registration.getAccessServiceWiki(), ServerTypeClassification.METADATA_ACCESS_SERVER.getServerTypeName(), null, null));
            }
        }
        if (response.isEmpty()) {
            return null;
        }
        return response;
    }

    public List<RegisteredOMAGService> getRegisteredEngineServices(String userId) throws UserNotAuthorizedException {
        OMAGServerPlatformInstanceMap.validateUserAsInvestigatorForPlatform(userId);
        ArrayList<RegisteredOMAGService> response = new ArrayList<RegisteredOMAGService>();
        List engineServiceRegistrationList = OMAGEngineServiceRegistration.getEngineServiceRegistrationList();
        if (!engineServiceRegistrationList.isEmpty()) {
            for (EngineServiceRegistrationEntry registration : engineServiceRegistrationList) {
                if (registration == null || registration.getEngineServiceOperationalStatus() != ServiceOperationalStatus.ENABLED) continue;
                response.add(OMAGServerPlatformInstanceMap.getServiceDescription(registration.getEngineServiceId(), registration.getEngineServiceFullName(), registration.getEngineServiceDevelopmentStatus(), registration.getEngineServiceURLMarker(), registration.getEngineServiceDescription(), registration.getEngineServiceWiki(), ServerTypeClassification.ENGINE_HOST.getServerTypeName(), registration.getEngineServicePartnerOMAS(), ServerTypeClassification.METADATA_ACCESS_SERVER.getServerTypeName()));
            }
        }
        if (response.isEmpty()) {
            return null;
        }
        return response;
    }

    public List<RegisteredOMAGService> getRegisteredIntegrationServices(String userId) throws UserNotAuthorizedException {
        OMAGServerPlatformInstanceMap.validateUserAsInvestigatorForPlatform(userId);
        return IntegrationServiceRegistry.getRegisteredIntegrationServices();
    }

    public List<RegisteredOMAGService> getRegisteredViewServices(String userId) throws UserNotAuthorizedException {
        OMAGServerPlatformInstanceMap.validateUserAsInvestigatorForPlatform(userId);
        ArrayList<RegisteredOMAGService> response = new ArrayList<RegisteredOMAGService>();
        List viewServiceRegistrationList = OMAGViewServiceRegistration.getViewServiceRegistrationList();
        if (!viewServiceRegistrationList.isEmpty()) {
            for (ViewServiceRegistrationEntry registration : viewServiceRegistrationList) {
                if (registration == null || registration.getViewServiceOperationalStatus() != ServiceOperationalStatus.ENABLED) continue;
                response.add(OMAGServerPlatformInstanceMap.getServiceDescription(registration.getViewServiceCode(), registration.getViewServiceFullName(), registration.getViewServiceDevelopmentStatus(), registration.getViewServiceURLMarker(), registration.getViewServiceDescription(), registration.getViewServiceWiki(), ServerTypeClassification.VIEW_SERVER.getServerTypeName(), registration.getViewServicePartnerService(), ServerTypeClassification.METADATA_ACCESS_SERVER.getServerTypeName()));
            }
        }
        if (response.isEmpty()) {
            return null;
        }
        return response;
    }

    public List<RegisteredOMAGService> getRegisteredGovernanceServices(String userId) throws UserNotAuthorizedException {
        OMAGServerPlatformInstanceMap.validateUserAsInvestigatorForPlatform(userId);
        ArrayList<RegisteredOMAGService> response = new ArrayList<RegisteredOMAGService>();
        for (GovernanceServicesDescription registration : GovernanceServicesDescription.values()) {
            if (registration == null) continue;
            response.add(OMAGServerPlatformInstanceMap.getServiceDescription(registration.getServiceCode(), registration.getServiceName(), registration.getServiceDevelopmentStatus(), registration.getServiceURLMarker(), registration.getServiceDescription(), registration.getServiceWiki(), registration.getServerType(), registration.getPartnerServiceName(), registration.getPartnerServerType()));
        }
        if (response.isEmpty()) {
            return null;
        }
        return response;
    }

    public List<RegisteredOMAGService> getRegisteredCommonServices(String userId) throws UserNotAuthorizedException {
        OMAGServerPlatformInstanceMap.validateUserAsInvestigatorForPlatform(userId);
        ArrayList<RegisteredOMAGService> response = new ArrayList<RegisteredOMAGService>();
        for (CommonServicesDescription registration : CommonServicesDescription.values()) {
            if (registration == null) continue;
            response.add(OMAGServerPlatformInstanceMap.getServiceDescription(registration.getServiceCode(), registration.getServiceName(), registration.getServiceDevelopmentStatus(), registration.getServiceURLMarker(), registration.getServiceDescription(), registration.getServiceWiki(), registration.getServerType(), registration.getPartnerServiceName(), registration.getPartnerServerType()));
        }
        if (response.isEmpty()) {
            return null;
        }
        return response;
    }

    public List<RegisteredOMAGService> getAllRegisteredServices(String userId) throws UserNotAuthorizedException {
        ArrayList<RegisteredOMAGService> response = new ArrayList<RegisteredOMAGService>();
        List<RegisteredOMAGService> services = this.getRegisteredCommonServices(userId);
        if (services != null && !services.isEmpty()) {
            response.addAll(services);
        }
        if ((services = this.getRegisteredAccessServices(userId)) != null && !services.isEmpty()) {
            response.addAll(services);
        }
        if ((services = this.getRegisteredIntegrationServices(userId)) != null && !services.isEmpty()) {
            response.addAll(services);
        }
        if ((services = this.getRegisteredViewServices(userId)) != null && !services.isEmpty()) {
            response.addAll(services);
        }
        if ((services = this.getRegisteredGovernanceServices(userId)) != null && !services.isEmpty()) {
            response.addAll(services);
        }
        return response;
    }

    private static synchronized OMAGServerInstance getActiveServerInstance(String serverName) {
        OMAGServerInstance serverInstance = activeServerInstanceMap.get(serverName);
        if (serverInstance == null) {
            serverInstance = inActiveServerInstanceMap.get(serverName);
            if (serverInstance == null) {
                serverInstance = new OMAGServerInstance(serverName);
                activeServerInstanceMap.put(serverName, serverInstance);
            } else {
                activeServerInstanceMap.put(serverName, serverInstance);
                inActiveServerInstanceMap.remove(serverName);
            }
        }
        return serverInstance;
    }

    private static synchronized void setInstanceForPlatform(String serverName, String serverType, String serviceName, OMAGServerServiceInstance instance) {
        OMAGServerInstance serverInstance = OMAGServerPlatformInstanceMap.getActiveServerInstance(serverName);
        serverInstance.registerService(serviceName, instance);
        if (serverType != null) {
            serverInstance.setServerType(serverType);
        }
    }

    private static synchronized OpenMetadataServerSecurityVerifier setServerActiveWithSecurity(String localServerUserId, String serverName, AuditLog auditLog, Connection connection) throws InvalidParameterException {
        OMAGServerInstance serverInstance = OMAGServerPlatformInstanceMap.getActiveServerInstance(serverName);
        serverInstance.initialize();
        return serverInstance.registerSecurityValidator(localServerUserId, auditLog, connection);
    }

    private static synchronized String getServerInstanceType(String userId, String serverName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException {
        OMAGServerPlatformInstanceMap.validateUserAsInvestigatorForPlatform(userId);
        OMAGServerInstance serverInstance = activeServerInstanceMap.get(serverName);
        if (serverInstance != null) {
            return serverInstance.getServerType();
        }
        OMAGServerPlatformInstanceMap.handleBadServerName(userId, serverName, serviceOperationName);
        return null;
    }

    private static synchronized ServerStatus getServerInstanceStatus(String userId, String serverName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException {
        OMAGServerPlatformInstanceMap.validateUserAsInvestigatorForPlatform(userId);
        OMAGServerInstance serverInstance = activeServerInstanceMap.get(serverName);
        boolean isActive = true;
        if (serverInstance == null) {
            serverInstance = inActiveServerInstanceMap.get(serverName);
            isActive = false;
        }
        if (serverInstance != null) {
            ServerStatus serverStatus = new ServerStatus();
            serverStatus.setServerName(serverName);
            serverStatus.setServerType(serverInstance.getServerType());
            serverStatus.setIsActive(isActive);
            serverStatus.setServerStartTime(serverInstance.getServerStartTime());
            serverStatus.setServerEndTime(serverInstance.getServerEndTime());
            serverStatus.setServerHistory(serverInstance.getServerHistory());
            return serverStatus;
        }
        OMAGServerPlatformInstanceMap.handleBadServerName(userId, serverName, serviceOperationName);
        return null;
    }

    private static synchronized boolean isServerInstanceActive(String userId, String serverName) throws UserNotAuthorizedException {
        OMAGServerPlatformInstanceMap.validateUserAsInvestigatorForPlatform(userId);
        return activeServerInstanceMap.get(serverName) != null;
    }

    private static synchronized boolean isServerInstanceKnown(String userId, String serverName) throws UserNotAuthorizedException {
        OMAGServerPlatformInstanceMap.validateUserAsInvestigatorForPlatform(userId);
        return activeServerInstanceMap.get(serverName) != null || inActiveServerInstanceMap.get(serverName) != null;
    }

    private static synchronized OMAGServerServiceInstance getInstanceForPlatform(String userId, String serverName, String serviceName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        OMAGServerInstance serverInstance = activeServerInstanceMap.get(serverName);
        if (serverInstance != null) {
            OpenMetadataServerSecurityVerifier serverSecurityVerifier = serverInstance.getSecurityVerifier();
            try {
                serverSecurityVerifier.validateUserForServer(userId);
                serverSecurityVerifier.validateUserForService(userId, serviceName);
                serverSecurityVerifier.validateUserForServiceOperation(userId, serviceName, serviceOperationName);
            }
            catch (UserNotAuthorizedException error) {
                throw new UserNotAuthorizedException(error);
            }
            return serverInstance.getRegisteredService(userId, serviceName, serviceOperationName);
        }
        OMAGServerPlatformInstanceMap.handleBadServerName(userId, serverName, serviceOperationName);
        return null;
    }

    private static synchronized List<String> getActiveServerListForPlatform(String userId) throws UserNotAuthorizedException {
        try {
            OpenMetadataPlatformSecurityVerifier.validateUserAsInvestigatorForPlatform((String)userId);
        }
        catch (UserNotAuthorizedException error) {
            throw new UserNotAuthorizedException(error);
        }
        Set<String> activeServerSet = activeServerInstanceMap.keySet();
        if (activeServerSet.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(activeServerSet);
    }

    private static synchronized List<String> getKnownServerListForPlatform(String userId) throws UserNotAuthorizedException {
        try {
            OpenMetadataPlatformSecurityVerifier.validateUserAsInvestigatorForPlatform((String)userId);
        }
        catch (UserNotAuthorizedException error) {
            throw new UserNotAuthorizedException(error);
        }
        ArrayList<String> knownServerList = new ArrayList<String>(activeServerInstanceMap.keySet());
        knownServerList.addAll(inActiveServerInstanceMap.keySet());
        if (knownServerList.isEmpty()) {
            return null;
        }
        return knownServerList;
    }

    private static synchronized void validateUserAsServerInvestigator(String userId, OMAGServerInstance serverInstance) throws UserNotAuthorizedException {
        if (serverInstance != null) {
            OpenMetadataServerSecurityVerifier serverSecurityVerifier = serverInstance.getSecurityVerifier();
            try {
                serverSecurityVerifier.validateUserForServer(userId);
                serverSecurityVerifier.validateUserAsServerInvestigator(userId);
            }
            catch (UserNotAuthorizedException error) {
                throw new UserNotAuthorizedException(error);
            }
        }
    }

    private static synchronized Date getServerStartTimeFromPlatform(String userId, String serverName) throws InvalidParameterException, UserNotAuthorizedException {
        String methodName = "getServerStartTimeFromPlatform";
        OMAGServerInstance serverInstance = activeServerInstanceMap.get(serverName);
        if (serverInstance == null) {
            serverInstance = inActiveServerInstanceMap.get(serverName);
        }
        if (serverInstance != null) {
            OMAGServerPlatformInstanceMap.validateUserAsServerInvestigator(userId, serverInstance);
            return serverInstance.getServerStartTime();
        }
        OMAGServerPlatformInstanceMap.handleBadServerName(userId, serverName, "getServerStartTimeFromPlatform");
        return null;
    }

    private static synchronized Date getServerEndTimeFromPlatform(String userId, String serverName) throws InvalidParameterException, UserNotAuthorizedException {
        String methodName = "getServerEndTimeFromPlatform";
        OMAGServerInstance serverInstance = activeServerInstanceMap.get(serverName);
        if (serverInstance == null) {
            serverInstance = inActiveServerInstanceMap.get(serverName);
        }
        if (serverInstance != null) {
            OMAGServerPlatformInstanceMap.validateUserAsServerInvestigator(userId, serverInstance);
            return serverInstance.getServerEndTime();
        }
        OMAGServerPlatformInstanceMap.handleBadServerName(userId, serverName, "getServerEndTimeFromPlatform");
        return null;
    }

    private static synchronized List<OMAGServerInstanceHistory> getServerHistoryFromPlatform(String userId, String serverName) throws InvalidParameterException, UserNotAuthorizedException {
        String methodName = "getServerHistoryFromPlatform";
        OMAGServerInstance serverInstance = activeServerInstanceMap.get(serverName);
        if (serverInstance == null) {
            serverInstance = inActiveServerInstanceMap.get(serverName);
        }
        if (serverInstance != null) {
            OMAGServerPlatformInstanceMap.validateUserAsServerInvestigator(userId, serverInstance);
            return serverInstance.getServerHistory();
        }
        OMAGServerPlatformInstanceMap.handleBadServerName(userId, serverName, "getServerHistoryFromPlatform");
        return null;
    }

    private static synchronized List<String> getActiveServicesForServerOnPlatform(String userId, String serverName) throws InvalidParameterException, UserNotAuthorizedException {
        String methodName = "getActiveServicesForServerOnPlatform";
        OMAGServerInstance serverInstance = activeServerInstanceMap.get(serverName);
        if (serverInstance != null) {
            OMAGServerPlatformInstanceMap.validateUserAsServerInvestigator(userId, serverInstance);
            return serverInstance.getConfiguredServices();
        }
        serverInstance = inActiveServerInstanceMap.get(serverName);
        if (serverInstance != null) {
            OMAGServerPlatformInstanceMap.validateUserAsServerInvestigator(userId, serverInstance);
        } else {
            OMAGServerPlatformInstanceMap.handleBadServerName(userId, serverName, "getActiveServicesForServerOnPlatform");
        }
        return null;
    }

    private static synchronized void removeInstanceForPlatform(String serverName, String serviceName) {
        OMAGServerInstance serverInstance = activeServerInstanceMap.get(serverName);
        if (serverInstance != null) {
            serverInstance.unRegisterService(serviceName);
        }
    }

    private static synchronized void setServerInActive(String userId, String serverName, String methodName) throws InvalidParameterException, PropertyServerException {
        OMAGServerInstance serverInstance = activeServerInstanceMap.get(serverName);
        if (serverInstance == null) {
            OMAGServerPlatformInstanceMap.handleBadServerName(userId, serverName, methodName);
        } else {
            try {
                serverInstance.shutdown(methodName);
                inActiveServerInstanceMap.put(serverName, serverInstance);
                activeServerInstanceMap.remove(serverName);
            }
            catch (Exception error) {
                inActiveServerInstanceMap.put(serverName, serverInstance);
                activeServerInstanceMap.remove(serverName);
                throw error;
            }
        }
    }

    private static synchronized OpenMetadataServerSecurityVerifier getServerSecurityVerifierForPlatform(String userId, String serverName) throws InvalidParameterException {
        String methodName = "getServerSecurityVerifierForPlatform";
        OMAGServerInstance serverInstance = activeServerInstanceMap.get(serverName);
        if (serverInstance != null) {
            return serverInstance.getSecurityVerifier();
        }
        OMAGServerPlatformInstanceMap.handleBadServerName(userId, serverName, "getServerSecurityVerifierForPlatform");
        return null;
    }

    private static void handleBadServerName(String userId, String serverName, String methodName) throws InvalidParameterException {
        HashMap<String, String> debugProperties = new HashMap<String, String>();
        String serverNameProperty = "serverName";
        debugProperties.put("serverName", serverName);
        throw new InvalidParameterException(OMAGServerInstanceErrorCode.SERVER_NOT_AVAILABLE.getMessageDefinition(serverName, userId), OMAGServerPlatformInstanceMap.class.getName(), methodName, "serverName", debugProperties);
    }

    public String getServerType(String userId, String serverName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException {
        return OMAGServerPlatformInstanceMap.getServerInstanceType(userId, serverName, serviceOperationName);
    }

    public ServerStatus getServerStatus(String userId, String serverName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException {
        return OMAGServerPlatformInstanceMap.getServerInstanceStatus(userId, serverName, serviceOperationName);
    }

    public boolean isServerActive(String userId, String serverName) throws UserNotAuthorizedException {
        return OMAGServerPlatformInstanceMap.isServerInstanceActive(userId, serverName);
    }

    public boolean isServerKnown(String userId, String serverName) throws UserNotAuthorizedException {
        return OMAGServerPlatformInstanceMap.isServerInstanceKnown(userId, serverName);
    }

    public Date getServerStartTime(String userId, String serverName) throws InvalidParameterException, UserNotAuthorizedException {
        return OMAGServerPlatformInstanceMap.getServerStartTimeFromPlatform(userId, serverName);
    }

    public Date getServerEndTime(String userId, String serverName) throws InvalidParameterException, UserNotAuthorizedException {
        return OMAGServerPlatformInstanceMap.getServerEndTimeFromPlatform(userId, serverName);
    }

    public List<OMAGServerInstanceHistory> getServerHistory(String userId, String serverName) throws InvalidParameterException, UserNotAuthorizedException {
        return OMAGServerPlatformInstanceMap.getServerHistoryFromPlatform(userId, serverName);
    }

    void addServiceInstanceToPlatform(String serverName, String serverType, String serviceName, OMAGServerServiceInstance instance) {
        OMAGServerPlatformInstanceMap.setInstanceForPlatform(serverName, serverType, serviceName, instance);
    }

    public OpenMetadataServerSecurityVerifier startUpServerInstance(String localServerUserId, String serverName, AuditLog auditLog, Connection connection) throws InvalidParameterException {
        return OMAGServerPlatformInstanceMap.setServerActiveWithSecurity(localServerUserId, serverName, auditLog, connection);
    }

    public void shutdownServerInstance(String userId, String serverName, String methodName) throws InvalidParameterException, PropertyServerException {
        OMAGServerPlatformInstanceMap.setServerInActive(userId, serverName, methodName);
    }

    OMAGServerServiceInstance getServiceInstance(String userId, String serverName, String serviceName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return OMAGServerPlatformInstanceMap.getInstanceForPlatform(userId, serverName, serviceName, serviceOperationName);
    }

    void removeServiceInstanceFromPlatform(String serverName, String serviceName) {
        OMAGServerPlatformInstanceMap.removeInstanceForPlatform(serverName, serviceName);
    }

    OpenMetadataServerSecurityVerifier getServerSecurityVerifier(String userId, String serverName) throws InvalidParameterException {
        return OMAGServerPlatformInstanceMap.getServerSecurityVerifierForPlatform(userId, serverName);
    }

    public List<String> getActiveServerList(String userId) throws UserNotAuthorizedException {
        return OMAGServerPlatformInstanceMap.getActiveServerListForPlatform(userId);
    }

    public List<String> getKnownServerList(String userId) throws UserNotAuthorizedException {
        return OMAGServerPlatformInstanceMap.getKnownServerListForPlatform(userId);
    }

    public List<String> getActiveServicesForServer(String userId, String serverName) throws InvalidParameterException, UserNotAuthorizedException {
        return OMAGServerPlatformInstanceMap.getActiveServicesForServerOnPlatform(userId, serverName);
    }
}

