/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.myprofile.server;

import java.util.regex.Pattern;
import org.odpi.openmetadata.accessservices.communityprofile.client.OrganizationManagement;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceDescription;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.commonservices.multitenant.OMVSServiceInstanceHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.viewservices.myprofile.server.MyProfileInstance;
import org.odpi.openmetadata.viewservices.myprofile.server.MyProfileRegistration;

public class MyProfileInstanceHandler
extends OMVSServiceInstanceHandler {
    public MyProfileInstanceHandler() {
        super(ViewServiceDescription.MY_PROFILE.getViewServiceName());
        MyProfileRegistration.registerViewService();
    }

    private String setInsensitive(String searchString, boolean insensitive) {
        return insensitive ? "(?i)" + searchString : searchString;
    }

    public String getStartsWithRegex(String searchString, boolean insensitive) {
        return searchString == null ? null : this.setInsensitive(this.getExactMatchRegex(searchString, false) + ".*", insensitive);
    }

    public String getEndsWithRegex(String searchString, boolean insensitive) {
        return searchString == null ? null : this.setInsensitive(".*" + this.getExactMatchRegex(searchString, false), insensitive);
    }

    String getExactMatchRegex(String searchString, boolean insensitive) {
        return searchString == null ? null : this.setInsensitive(Pattern.quote(searchString), insensitive);
    }

    public String getSearchString(String requestedSearch, boolean startsWith, boolean endsWith, boolean ignoreCase) {
        if (requestedSearch == null || "".equals(requestedSearch.trim())) {
            requestedSearch = ".*";
        } else {
            requestedSearch = requestedSearch.trim();
            requestedSearch = startsWith && endsWith ? this.getExactMatchRegex(requestedSearch, ignoreCase) : (startsWith ? this.getStartsWithRegex(requestedSearch, ignoreCase) : (endsWith ? this.getEndsWithRegex(requestedSearch, ignoreCase) : this.getStartsWithRegex(this.getEndsWithRegex(requestedSearch, false), ignoreCase)));
        }
        return requestedSearch;
    }

    public OrganizationManagement getOrganizationManagementClient(String userId, String serverName, String serviceOperationName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        MyProfileInstance instance = (MyProfileInstance)this.getServerServiceInstance(userId, serverName, serviceOperationName);
        if (instance != null) {
            return instance.getOrganizationManagement();
        }
        return null;
    }
}

