/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.myprofile.server;

import java.util.Map;
import org.odpi.openmetadata.accessservices.communityprofile.client.OrganizationManagement;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelements.ActorProfileElement;
import org.odpi.openmetadata.accessservices.communityprofile.properties.ActorProfileProperties;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.viewservices.myprofile.metadataelements.PersonalProfileUniverse;
import org.odpi.openmetadata.viewservices.myprofile.properties.PersonalProfileProperties;
import org.odpi.openmetadata.viewservices.myprofile.rest.PersonalProfileResponse;
import org.odpi.openmetadata.viewservices.myprofile.server.MyProfileInstanceHandler;
import org.slf4j.LoggerFactory;

public class MyProfileRESTServices {
    private static final MyProfileInstanceHandler instanceHandler = new MyProfileInstanceHandler();
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(MyProfileRESTServices.class), instanceHandler.getServiceName());

    public PersonalProfileResponse getMyProfile(String serverName, String userId) {
        String methodName = "getMyProfile";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMyProfile");
        PersonalProfileResponse response = new PersonalProfileResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMyProfile");
            OrganizationManagement client = instanceHandler.getOrganizationManagementClient(userId, serverName, "getMyProfile");
            ActorProfileElement actorProfileElement = client.getActorProfileByUserId(userId, userId);
            if (actorProfileElement != null) {
                PersonalProfileUniverse personalProfileUniverse = new PersonalProfileUniverse();
                PersonalProfileProperties profileProperties = new PersonalProfileProperties();
                ActorProfileProperties actorProfileProperties = actorProfileElement.getProfileProperties();
                Map extendedProperties = actorProfileProperties.getExtendedProperties();
                profileProperties.setQualifiedName(actorProfileProperties.getQualifiedName());
                profileProperties.setKnownName(actorProfileProperties.getKnownName());
                profileProperties.setDescription(actorProfileProperties.getDescription());
                profileProperties.setPronouns(this.getExtendedProperty(extendedProperties, "pronouns"));
                profileProperties.setTitle(this.getExtendedProperty(extendedProperties, "title"));
                profileProperties.setInitials(this.getExtendedProperty(extendedProperties, "initials"));
                profileProperties.setGivenNames(this.getExtendedProperty(extendedProperties, "givenNames"));
                profileProperties.setSurname(this.getExtendedProperty(extendedProperties, "surname"));
                profileProperties.setFullName(this.getExtendedProperty(extendedProperties, "fullName"));
                profileProperties.setPreferredLanguage(this.getExtendedProperty(extendedProperties, "preferredLanguage"));
                profileProperties.setJobTitle(this.getExtendedProperty(extendedProperties, "jobTitle"));
                profileProperties.setEmployeeNumber(this.getExtendedProperty(extendedProperties, "employeeNumber"));
                profileProperties.setEmployeeType(this.getExtendedProperty(extendedProperties, "employeeType"));
                profileProperties.setIsPublic(this.getExtendedBooleanProperty(extendedProperties, "isPublic"));
                profileProperties.setAdditionalProperties(actorProfileProperties.getAdditionalProperties());
                profileProperties.setEffectiveFrom(actorProfileProperties.getEffectiveFrom());
                profileProperties.setEffectiveTo(actorProfileProperties.getEffectiveTo());
                personalProfileUniverse.setElementHeader(actorProfileElement.getElementHeader());
                personalProfileUniverse.setProfileProperties(profileProperties);
                personalProfileUniverse.setContributionRecord(actorProfileElement.getContributionRecord());
                personalProfileUniverse.setContactMethods(actorProfileElement.getContactMethods());
                personalProfileUniverse.setPeers(actorProfileElement.getPeers());
                personalProfileUniverse.setRoles(actorProfileElement.getPersonRoles());
                personalProfileUniverse.setUserIdentities(actorProfileElement.getUserIdentities());
                response.setPersonalProfile(personalProfileUniverse);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getMyProfile", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private String getExtendedProperty(Map<String, Object> extendedProperties, String propertyName) {
        Object propertyValue;
        if (extendedProperties != null && (propertyValue = extendedProperties.get(propertyName)) != null) {
            return propertyValue.toString();
        }
        return null;
    }

    private boolean getExtendedBooleanProperty(Map<String, Object> extendedProperties, String propertyName) {
        Object propertyValue;
        if (extendedProperties != null && (propertyValue = extendedProperties.get(propertyName)) instanceof Boolean) {
            Boolean booleanValue = (Boolean)propertyValue;
            return booleanValue;
        }
        return true;
    }
}

