/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.myprofile.server;

import java.util.ArrayList;
import java.util.Map;
import org.odpi.openmetadata.accessservices.communityprofile.client.OrganizationManagement;
import org.odpi.openmetadata.accessservices.communityprofile.client.ToDoActionManagement;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.PersonalProfileResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ToDoRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ToDoResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ToDoStatusRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ToDoStatusSearchString;
import org.odpi.openmetadata.commonservices.ffdc.rest.ToDosResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ActorProfileElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.PersonRoleElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.PersonalProfileUniverse;
import org.odpi.openmetadata.frameworks.openmetadata.properties.actions.ToDoActionTargetProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.actions.ToDoProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.actors.ActorProfileProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.actors.PersonalProfileProperties;
import org.odpi.openmetadata.tokencontroller.TokenController;
import org.odpi.openmetadata.viewservices.myprofile.server.MyProfileInstanceHandler;
import org.slf4j.LoggerFactory;

public class MyProfileRESTServices
extends TokenController {
    private static final MyProfileInstanceHandler instanceHandler = new MyProfileInstanceHandler();
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(MyProfileRESTServices.class), instanceHandler.getServiceName());

    public PersonalProfileResponse getMyProfile(String serverName) {
        String methodName = "getMyProfile";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getMyProfile");
        PersonalProfileResponse response = new PersonalProfileResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getMyProfile");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMyProfile");
            OrganizationManagement client = instanceHandler.getOrganizationManagementClient(userId, serverName, "getMyProfile");
            ActorProfileElement actorProfileElement = client.getActorProfileByUserId(userId, userId);
            if (actorProfileElement != null) {
                PersonalProfileUniverse personalProfileUniverse = new PersonalProfileUniverse();
                PersonalProfileProperties profileProperties = new PersonalProfileProperties();
                ActorProfileProperties actorProfileProperties = actorProfileElement.getProfileProperties();
                Map extendedProperties = actorProfileProperties.getExtendedProperties();
                profileProperties.setQualifiedName(actorProfileProperties.getQualifiedName());
                profileProperties.setKnownName(actorProfileProperties.getKnownName());
                profileProperties.setDescription(actorProfileProperties.getDescription());
                profileProperties.setPronouns(this.getExtendedProperty(extendedProperties, "pronouns"));
                profileProperties.setTitle(this.getExtendedProperty(extendedProperties, "title"));
                profileProperties.setInitials(this.getExtendedProperty(extendedProperties, "initials"));
                profileProperties.setGivenNames(this.getExtendedProperty(extendedProperties, "givenNames"));
                profileProperties.setSurname(this.getExtendedProperty(extendedProperties, "surname"));
                profileProperties.setFullName(this.getExtendedProperty(extendedProperties, "fullName"));
                profileProperties.setPreferredLanguage(this.getExtendedProperty(extendedProperties, "preferredLanguage"));
                profileProperties.setJobTitle(this.getExtendedProperty(extendedProperties, "jobTitle"));
                profileProperties.setEmployeeNumber(this.getExtendedProperty(extendedProperties, "employeeNumber"));
                profileProperties.setEmployeeType(this.getExtendedProperty(extendedProperties, "employeeType"));
                profileProperties.setIsPublic(this.getExtendedBooleanProperty(extendedProperties, "isPublic"));
                profileProperties.setAdditionalProperties(actorProfileProperties.getAdditionalProperties());
                profileProperties.setEffectiveFrom(actorProfileProperties.getEffectiveFrom());
                profileProperties.setEffectiveTo(actorProfileProperties.getEffectiveTo());
                personalProfileUniverse.setElementHeader(actorProfileElement.getElementHeader());
                personalProfileUniverse.setProfileProperties(profileProperties);
                personalProfileUniverse.setContributionRecord(actorProfileElement.getContributionRecord());
                personalProfileUniverse.setContactMethods(actorProfileElement.getContactMethods());
                personalProfileUniverse.setUserIdentities(actorProfileElement.getUserIdentities());
                personalProfileUniverse.setPeers(actorProfileElement.getPeers());
                if (actorProfileElement.getPersonRoles() != null) {
                    ArrayList<PersonRoleElement> personRoles = new ArrayList<PersonRoleElement>();
                    for (ElementStub personRoleStub : actorProfileElement.getPersonRoles()) {
                        PersonRoleElement personRoleElement = client.getPersonRoleByGUID(userId, personRoleStub.getGUID());
                        if (personRoleElement == null) continue;
                        personRoles.add(personRoleElement);
                    }
                    if (!personRoles.isEmpty()) {
                        personalProfileUniverse.setRoles(personRoles);
                    }
                }
                response.setPersonalProfile(personalProfileUniverse);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getMyProfile", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createToDo(String serverName, ToDoRequestBody requestBody) {
        String methodName = "createToDo";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "createToDo");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "createToDo");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createToDo");
            ToDoActionManagement handler = instanceHandler.getToDoActionManagementClient(userId, serverName, "createToDo");
            if (requestBody != null) {
                response.setGUID(handler.createToDo(userId, requestBody.getOriginatorGUID(), requestBody.getActionSponsorGUID(), requestBody.getAssignToActorGUID(), requestBody.getNewActionTargetProperties(), requestBody.getProperties()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createToDo", serverName, SearchStringRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createToDo", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateToDo(String serverName, String toDoGUID, boolean isMergeUpdate, ToDoProperties toDoProperties) {
        String methodName = "updateToDo";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "updateToDo");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "updateToDo");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateToDo");
            ToDoActionManagement handler = instanceHandler.getToDoActionManagementClient(userId, serverName, "updateToDo");
            handler.updateToDo(userId, toDoGUID, isMergeUpdate, toDoProperties);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateToDo", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateActionTargetProperties(String serverName, String actionTargetGUID, boolean isMergeUpdate, ToDoActionTargetProperties actionTargetProperties) {
        String methodName = "updateActionTargetProperties";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "updateActionTargetProperties");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "updateActionTargetProperties");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateActionTargetProperties");
            ToDoActionManagement handler = instanceHandler.getToDoActionManagementClient(userId, serverName, "updateActionTargetProperties");
            handler.updateActionTargetProperties(userId, actionTargetGUID, isMergeUpdate, actionTargetProperties);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateActionTargetProperties", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse reassignToDo(String serverName, String toDoGUID, String actorGUID, NullRequestBody requestBody) {
        String methodName = "reassignToDo";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "reassignToDo");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "reassignToDo");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "reassignToDo");
            ToDoActionManagement handler = instanceHandler.getToDoActionManagementClient(userId, serverName, "reassignToDo");
            handler.reassignToDo(userId, toDoGUID, actorGUID);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "reassignToDo", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteToDo(String serverName, String toDoGUID, NullRequestBody requestBody) {
        String methodName = "deleteToDo";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "deleteToDo");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "deleteToDo");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteToDo");
            ToDoActionManagement handler = instanceHandler.getToDoActionManagementClient(userId, serverName, "deleteToDo");
            handler.deleteToDo(userId, toDoGUID);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteToDo", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ToDoResponse getToDo(String serverName, String toDoGUID) {
        String methodName = "getToDo";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getToDo");
        ToDoResponse response = new ToDoResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getToDo");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getToDo");
            ToDoActionManagement handler = instanceHandler.getToDoActionManagementClient(userId, serverName, "getToDo");
            response.setElement(handler.getToDo(userId, toDoGUID));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getToDo", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ToDosResponse getActionsForActionTarget(String serverName, String elementGUID, int startFrom, int pageSize, ToDoStatusRequestBody requestBody) {
        String methodName = "getActionsForActionTarget";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getActionsForActionTarget");
        ToDosResponse response = new ToDosResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getActionsForActionTarget");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getActionsForActionTarget");
            ToDoActionManagement handler = instanceHandler.getToDoActionManagementClient(userId, serverName, "getActionsForActionTarget");
            if (requestBody != null) {
                response.setElements(handler.getActionsForActionTarget(userId, elementGUID, requestBody.getToDoStatus(), startFrom, pageSize));
            } else {
                response.setElements(handler.getActionsForActionTarget(userId, elementGUID, null, startFrom, pageSize));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getActionsForActionTarget", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ToDosResponse getActionsForSponsor(String serverName, String elementGUID, int startFrom, int pageSize, ToDoStatusRequestBody requestBody) {
        String methodName = "getActionsForSponsor";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getActionsForSponsor");
        ToDosResponse response = new ToDosResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getActionsForSponsor");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getActionsForSponsor");
            ToDoActionManagement handler = instanceHandler.getToDoActionManagementClient(userId, serverName, "getActionsForSponsor");
            if (requestBody != null) {
                response.setElements(handler.getActionsForSponsor(userId, elementGUID, requestBody.getToDoStatus(), startFrom, pageSize));
            } else {
                response.setElements(handler.getActionsForSponsor(userId, elementGUID, null, startFrom, pageSize));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getActionsForSponsor", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ToDosResponse getAssignedActions(String serverName, String actorGUID, int startFrom, int pageSize, ToDoStatusRequestBody requestBody) {
        String methodName = "getAssignedActions";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getAssignedActions");
        ToDosResponse response = new ToDosResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getAssignedActions");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssignedActions");
            ToDoActionManagement handler = instanceHandler.getToDoActionManagementClient(userId, serverName, "getAssignedActions");
            if (requestBody != null) {
                response.setElements(handler.getAssignedActions(userId, actorGUID, requestBody.getToDoStatus(), startFrom, pageSize));
            } else {
                response.setElements(handler.getAssignedActions(userId, actorGUID, null, startFrom, pageSize));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAssignedActions", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ToDosResponse findToDos(String serverName, int startFrom, int pageSize, boolean startsWith, boolean endsWith, boolean ignoreCase, ToDoStatusSearchString requestBody) {
        String methodName = "findToDos";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findToDos");
        ToDosResponse response = new ToDosResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findToDos");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findToDos");
            ToDoActionManagement handler = instanceHandler.getToDoActionManagementClient(userId, serverName, "findToDos");
            if (requestBody != null) {
                response.setElements(handler.findToDos(userId, instanceHandler.getSearchString(requestBody.getSearchString(), startsWith, endsWith, ignoreCase), requestBody.getToDoStatus(), startFrom, pageSize));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findToDos", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findToDos", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ToDosResponse getToDosByType(String serverName, String toDoType, int startFrom, int pageSize, ToDoStatusRequestBody requestBody) {
        String methodName = "getToDosByType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getToDosByType");
        ToDosResponse response = new ToDosResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getToDosByType");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getToDosByType");
            ToDoActionManagement handler = instanceHandler.getToDoActionManagementClient(userId, serverName, "getToDosByType");
            if (requestBody != null) {
                response.setElements(handler.getToDosByType(userId, toDoType, requestBody.getToDoStatus(), startFrom, pageSize));
            } else {
                response.setElements(handler.getToDosByType(userId, toDoType, null, startFrom, pageSize));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getToDosByType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private String getExtendedProperty(Map<String, Object> extendedProperties, String propertyName) {
        Object propertyValue;
        if (extendedProperties != null && (propertyValue = extendedProperties.get(propertyName)) != null) {
            return propertyValue.toString();
        }
        return null;
    }

    private boolean getExtendedBooleanProperty(Map<String, Object> extendedProperties, String propertyName) {
        Object propertyValue;
        if (extendedProperties != null && (propertyValue = extendedProperties.get(propertyName)) instanceof Boolean) {
            Boolean booleanValue = (Boolean)propertyValue;
            return booleanValue;
        }
        return true;
    }
}

