/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.myprofile.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.PersonalProfileResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ToDoRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ToDoResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ToDoStatusRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ToDoStatusSearchString;
import org.odpi.openmetadata.commonservices.ffdc.rest.ToDosResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.openmetadata.properties.actions.ToDoActionTargetProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.actions.ToDoProperties;
import org.odpi.openmetadata.viewservices.myprofile.server.MyProfileRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/api/open-metadata/my-profile"})
@Tag(name="API: My Profile OMVS", description="The My Profile OMVS provides APIs for retrieving and updating a user's personal profile, roles and actions.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/my-profile/overview/"))
public class MyProfileResource {
    private final MyProfileRESTServices restAPI = new MyProfileRESTServices();

    @GetMapping(path={""})
    @Operation(summary="getMyProfile", description="Return the personal profile of the logged on user (details of the user is extracted from the bearer token).", externalDocs=@ExternalDocumentation(description="Personal Profiles", url="https://egeria-project.org/concepts/personal-profile"))
    public PersonalProfileResponse getMyProfile(@PathVariable String serverName) {
        return this.restAPI.getMyProfile(serverName);
    }

    @PostMapping(path={"/to-dos"})
    @Operation(summary="createToDo", description="Create a new to do action and link it to the supplied actor and targets (if applicable).", externalDocs=@ExternalDocumentation(description="To Dos", url="https://egeria-project.org/concepts/to-do"))
    public GUIDResponse createToDo(@PathVariable String serverName, @RequestBody ToDoRequestBody requestBody) {
        return this.restAPI.createToDo(serverName, requestBody);
    }

    @PostMapping(path={"/to-dos/{toDoGUID}"})
    @Operation(summary="updateToDo", description="Update the properties associated with a to do.", externalDocs=@ExternalDocumentation(description="To Dos", url="https://egeria-project.org/concepts/to-do"))
    public VoidResponse updateToDo(@PathVariable String serverName, @PathVariable String toDoGUID, @RequestParam boolean isMergeUpdate, @RequestBody ToDoProperties toDoProperties) {
        return this.restAPI.updateToDo(serverName, toDoGUID, isMergeUpdate, toDoProperties);
    }

    @PostMapping(path={"/to-dos/action-targets/{actionTargetGUID}"})
    @Operation(summary="updateActionTargetProperties", description="Update the properties associated with an Action Target for a to do.", externalDocs=@ExternalDocumentation(description="To Dos", url="https://egeria-project.org/concepts/to-do"))
    public VoidResponse updateActionTargetProperties(@PathVariable String serverName, @PathVariable String actionTargetGUID, @RequestParam boolean isMergeUpdate, @RequestBody ToDoActionTargetProperties actionTargetProperties) {
        return this.restAPI.updateActionTargetProperties(serverName, actionTargetGUID, isMergeUpdate, actionTargetProperties);
    }

    @PostMapping(path={"/to-dos/{toDoGUID}/reassign/{actorGUID}"})
    @Operation(summary="reassignToDo", description="Assign a to do to a new actor.  This will unassign all other actors previously assigned to the to do.", externalDocs=@ExternalDocumentation(description="To Dos", url="https://egeria-project.org/concepts/to-do"))
    public VoidResponse reassignToDo(@PathVariable String serverName, @PathVariable String toDoGUID, @PathVariable String actorGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.reassignToDo(serverName, toDoGUID, actorGUID, requestBody);
    }

    @PostMapping(path={"/to-dos/{toDoGUID}/delete"})
    @Operation(summary="deleteToDo", description="Delete an existing to do.", externalDocs=@ExternalDocumentation(description="To Dos", url="https://egeria-project.org/concepts/to-do"))
    public VoidResponse deleteToDo(@PathVariable String serverName, @PathVariable String toDoGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.deleteToDo(serverName, toDoGUID, requestBody);
    }

    @GetMapping(path={"/to-dos/{toDoGUID}"})
    @Operation(summary="getToDo", description="Retrieve a to do.", externalDocs=@ExternalDocumentation(description="To Dos", url="https://egeria-project.org/concepts/to-do"))
    public ToDoResponse getToDo(@PathVariable String serverName, @PathVariable String toDoGUID) {
        return this.restAPI.getToDo(serverName, toDoGUID);
    }

    @PostMapping(path={"/elements/{elementGUID}/action-targets/to-dos"})
    @Operation(summary="getActionsForActionTarget", description="Retrieve the to dos that are chained off of an action target element.", externalDocs=@ExternalDocumentation(description="To Dos", url="https://egeria-project.org/concepts/to-do"))
    public ToDosResponse getActionsForActionTarget(@PathVariable String serverName, @PathVariable String elementGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody(required=false) ToDoStatusRequestBody requestBody) {
        return this.restAPI.getActionsForActionTarget(serverName, elementGUID, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/sponsored/to-dos"})
    @Operation(summary="getActionsForSponsor", description="Retrieve the to dos that are chained off of a sponsor's element.", externalDocs=@ExternalDocumentation(description="To Dos", url="https://egeria-project.org/concepts/to-do"))
    public ToDosResponse getActionsForSponsor(@PathVariable String serverName, @PathVariable String elementGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody(required=false) ToDoStatusRequestBody requestBody) {
        return this.restAPI.getActionsForSponsor(serverName, elementGUID, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/actors/{actorGUID}/assigned/to-dos"})
    @Operation(summary="getAssignedActions", description="Retrieve the to dos that are assigned to a particular actor.", externalDocs=@ExternalDocumentation(description="To Dos", url="https://egeria-project.org/concepts/to-do"))
    public ToDosResponse getAssignedActions(@PathVariable String serverName, @PathVariable String actorGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody(required=false) ToDoStatusRequestBody requestBody) {
        return this.restAPI.getAssignedActions(serverName, actorGUID, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/to-dos/find-by-search-string"})
    @Operation(summary="findToDos", description="Retrieve the to dos that match the search string.", externalDocs=@ExternalDocumentation(description="To Dos", url="https://egeria-project.org/concepts/to-do"))
    public ToDosResponse findToDos(@PathVariable String serverName, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestBody ToDoStatusSearchString requestBody) {
        return this.restAPI.findToDos(serverName, startFrom, pageSize, startsWith, endsWith, ignoreCase, requestBody);
    }

    @PostMapping(path={"/to-dos/types/{toDoType}"})
    @Operation(summary="getToDosByType", description="Retrieve the to dos that match the supplied toDoType.", externalDocs=@ExternalDocumentation(description="To Dos", url="https://egeria-project.org/concepts/to-do"))
    public ToDosResponse getToDosByType(@PathVariable String serverName, @PathVariable String toDoType, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody(required=false) ToDoStatusRequestBody requestBody) {
        return this.restAPI.getToDosByType(serverName, toDoType, startFrom, pageSize, requestBody);
    }
}

