/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ReferenceableRequestBody;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.OwnerType;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AssetRequestBody
extends ReferenceableRequestBody {
    private static final long serialVersionUID = 1L;
    protected String displayName = null;
    protected String description = null;
    protected String owner = null;
    protected OwnerType ownerType = null;
    protected List<String> zoneMembership = null;
    protected String latestChange = null;

    public AssetRequestBody() {
    }

    public AssetRequestBody(AssetRequestBody template) {
        super(template);
        if (template != null) {
            this.displayName = template.getDisplayName();
            this.description = template.getDescription();
            this.owner = template.getOwner();
            this.ownerType = template.getOwnerType();
            this.zoneMembership = template.getZoneMembership();
            this.latestChange = template.getLatestChange();
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public OwnerType getOwnerType() {
        return this.ownerType;
    }

    public void setOwnerType(OwnerType ownerType) {
        this.ownerType = ownerType;
    }

    public List<String> getZoneMembership() {
        if (this.zoneMembership == null) {
            return null;
        }
        if (this.zoneMembership.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(this.zoneMembership);
    }

    public void setZoneMembership(List<String> zoneMembership) {
        this.zoneMembership = zoneMembership;
    }

    public String getLatestChange() {
        return this.latestChange;
    }

    public void setLatestChange(String latestChange) {
        this.latestChange = latestChange;
    }

    @Override
    public String toString() {
        return "AssetRequestBody{displayName='" + this.displayName + '\'' + ", description='" + this.description + '\'' + ", owner='" + this.owner + '\'' + ", ownerType=" + this.ownerType + ", zoneMembership=" + this.zoneMembership + ", latestChange='" + this.latestChange + '\'' + ", typeName='" + this.getTypeName() + '\'' + ", classifications=" + this.getClassifications() + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", additionalProperties=" + this.getAdditionalProperties() + ", meanings=" + this.getMeanings() + ", extendedProperties=" + this.getExtendedProperties() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetRequestBody requestBody = (AssetRequestBody)objectToCompare;
        return Objects.equals(this.getDisplayName(), requestBody.getDisplayName()) && Objects.equals(this.getDescription(), requestBody.getDescription()) && Objects.equals(this.getOwner(), requestBody.getOwner()) && this.getOwnerType() == requestBody.getOwnerType() && Objects.equals(this.getZoneMembership(), requestBody.getZoneMembership()) && Objects.equals(this.getLatestChange(), requestBody.getLatestChange());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getDisplayName(), this.getDescription(), this.getOwner(), this.getOwnerType(), this.getZoneMembership(), this.getLatestChange());
    }
}

