/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.OCFOMASAPIResponse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Note;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.NoteLog;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class NoteLogResponse
extends OCFOMASAPIResponse {
    private static final long serialVersionUID = 1L;
    private NoteLog noteLog = null;
    private List<Note> notes = null;
    private int noteCount = 0;

    public NoteLogResponse() {
    }

    public NoteLogResponse(NoteLogResponse template) {
        super(template);
        if (template != null) {
            this.noteLog = template.getNoteLog();
            this.notes = template.getNotes();
            this.noteCount = template.getNoteCount();
        }
    }

    public NoteLog getNoteLog() {
        return this.noteLog;
    }

    public void setNoteLog(NoteLog noteLog) {
        this.noteLog = noteLog;
    }

    public List<Note> getNotes() {
        if (this.notes == null) {
            return null;
        }
        if (this.notes.isEmpty()) {
            return null;
        }
        return new ArrayList<Note>(this.notes);
    }

    public void setNotes(List<Note> notes) {
        this.notes = notes;
    }

    public int getNoteCount() {
        return this.noteCount;
    }

    public void setNoteCount(int noteCount) {
        this.noteCount = noteCount;
    }

    @Override
    public String toString() {
        return "NoteLogResponse{noteLog=" + this.noteLog + ", notes=" + this.notes + ", noteCount=" + this.noteCount + ", relatedHTTPCode=" + this.getRelatedHTTPCode() + ", exceptionClassName='" + this.getExceptionClassName() + '\'' + ", exceptionErrorMessage='" + this.getExceptionErrorMessage() + '\'' + ", exceptionSystemAction='" + this.getExceptionSystemAction() + '\'' + ", exceptionUserAction='" + this.getExceptionUserAction() + '\'' + ", exceptionProperties=" + this.getExceptionProperties() + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || ((Object)((Object)this)).getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        NoteLogResponse that = (NoteLogResponse)((Object)objectToCompare);
        return this.getNoteCount() == that.getNoteCount() && Objects.equals(this.getNoteLog(), that.getNoteLog()) && Objects.equals(this.getNotes(), that.getNotes());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getNoteLog(), this.getNotes(), this.getNoteCount());
    }
}

