/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageSet;

public enum OMAGOCFErrorCode implements ExceptionMessageSet
{
    NULL_CONNECTION_PARAMETER(400, "OMAG-OCF-400-001", "The connection value passed on the {0} parameter of the {1} operation is null", "The system is unable to process the request without this value.", "Correct the code in the caller to provide the name."),
    NO_ASSET_PROPERTIES(400, "OMAG-OCF-400-002", "The request for the properties of asset {0} failed with the following message returned: {1}", "The system is unable to process the request.", "Use the information in the message to understand the nature of the problem and once it is resolved, retry the request."),
    NULL_CLASSIFICATION_NAME(400, "OMAG-OCF-400-003", "Service {0} is unable to process one of the classifications supplied on the {1} call because the classification name is null", "The system is unable to create a new instance because the classification might be important.", "Correct the list of classifications passed with this request."),
    BAD_CLASSIFICATION_PROPERTIES(400, "OMAG-OCF-400-004", "Service {0} is unable to process the properties supplied with classification {1}.  The associated error message was: {2}", "The system is unable to create a new instance with invalid properties in any of the classifications.", "Correct the classification parameters passed with this request."),
    OMRS_NOT_INITIALIZED(404, "OMAG-OCF-404-001", "The open metadata repository services are not initialized for the {0} operation", "The system is unable to connect to an open metadata repository.", "Check that the server where the Open Connector Framework metadata services are running is initialized correctly.  Correct any errors discovered and retry the request when the open metadata services are available."),
    NULL_CONNECTOR_RETURNED(500, "OMAG-OCF-500-001", "The requested connector for connection named {0} has not been created.  The connection was provided by the {1} service running in OMAG Server {2} at {3}", "The system is unable to create a connector which means some of its services will not work.", "This problem is likely to be caused by an incorrect connection object.  Check the settings on the Connectionand correct if necessary.  If the connection is correct, contact the Egeria community for help."),
    WRONG_TYPE_OF_CONNECTOR(500, "OMAG-OCF-500-002", "The connector generated from the connection named {0} return by the {1} service running in OMAG Server {2} at {3} is not of the required type. It should be an instance of {4}", "The system is unable to create the required connector which means some of its services will not work.", "Verify that the OMAG server is running and the OMAS service is correctly configured.");

    private ExceptionMessageDefinition messageDefinition;

    private OMAGOCFErrorCode(int httpErrorCode, String errorMessageId, String errorMessage, String systemAction, String userAction) {
        this.messageDefinition = new ExceptionMessageDefinition(httpErrorCode, errorMessageId, errorMessage, systemAction, userAction);
    }

    public ExceptionMessageDefinition getMessageDefinition() {
        return this.messageDefinition;
    }

    public ExceptionMessageDefinition getMessageDefinition(String ... params) {
        this.messageDefinition.setMessageParameters(params);
        return this.messageDefinition;
    }
}

