/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.PagedResponse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Meaning;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class MeaningsResponse
extends PagedResponse {
    private static final long serialVersionUID = 1L;
    private List<Meaning> meanings = null;
    private int startingFromElement = 0;

    public MeaningsResponse() {
    }

    public MeaningsResponse(MeaningsResponse template) {
        super(template);
        if (template != null) {
            this.meanings = template.getMeanings();
        }
    }

    public List<Meaning> getMeanings() {
        if (this.meanings == null) {
            return null;
        }
        if (this.meanings.isEmpty()) {
            return null;
        }
        ArrayList<Meaning> clonedList = new ArrayList<Meaning>();
        for (Meaning existingElement : this.meanings) {
            clonedList.add(new Meaning(existingElement));
        }
        return clonedList;
    }

    public void setMeanings(List<Meaning> meanings) {
        this.meanings = meanings;
    }

    @Override
    public String toString() {
        return "MeaningsResponse{meanings=" + this.meanings + ", startingFromElement=" + this.startingFromElement + ", exceptionClassName='" + this.getExceptionClassName() + "', exceptionCausedBy='" + this.getExceptionCausedBy() + "', actionDescription='" + this.getActionDescription() + "', relatedHTTPCode=" + this.getRelatedHTTPCode() + ", exceptionErrorMessage='" + this.getExceptionErrorMessage() + "', exceptionErrorMessageId='" + this.getExceptionErrorMessageId() + "', exceptionErrorMessageParameters=" + Arrays.toString(this.getExceptionErrorMessageParameters()) + ", exceptionSystemAction='" + this.getExceptionSystemAction() + "', exceptionUserAction='" + this.getExceptionUserAction() + "', exceptionProperties=" + this.getExceptionProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || ((Object)((Object)this)).getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        MeaningsResponse that = (MeaningsResponse)((Object)objectToCompare);
        return this.getStartingFromElement() == that.getStartingFromElement() && Objects.equals(this.getMeanings(), that.getMeanings());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getMeanings(), this.getStartingFromElement());
    }
}

