/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Asset;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.rest.PagedResponse;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AssetsResponse
extends PagedResponse {
    private List<Asset> assets = null;

    public AssetsResponse() {
    }

    public AssetsResponse(AssetsResponse template) {
        super(template);
        if (template != null) {
            this.assets = template.getAssets();
        }
    }

    public List<Asset> getAssets() {
        if (this.assets == null) {
            return null;
        }
        if (this.assets.isEmpty()) {
            return null;
        }
        ArrayList<Asset> clonedList = new ArrayList<Asset>();
        for (Asset existingElement : this.assets) {
            clonedList.add(new Asset(existingElement));
        }
        return clonedList;
    }

    public void setAssets(List<Asset> assets) {
        this.assets = assets;
    }

    @Override
    public String toString() {
        return "AssetsResponse{assets=" + this.assets + ", startingFromElement=" + this.getStartingFromElement() + ", relatedHTTPCode=" + this.getRelatedHTTPCode() + ", exceptionClassName='" + this.getExceptionClassName() + "', exceptionErrorMessage='" + this.getExceptionErrorMessage() + "', exceptionSystemAction='" + this.getExceptionSystemAction() + "', exceptionUserAction='" + this.getExceptionUserAction() + "', exceptionProperties=" + this.getExceptionProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || ((Object)((Object)this)).getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetsResponse that = (AssetsResponse)((Object)objectToCompare);
        return Objects.equals(this.getAssets(), that.getAssets());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getAssets());
    }
}

