/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ValidValue;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.rest.PagedResponse;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ValidValuesResponse
extends PagedResponse {
    private List<ValidValue> validValues = null;

    public ValidValuesResponse() {
    }

    public ValidValuesResponse(ValidValuesResponse template) {
        super(template);
        if (template != null) {
            this.validValues = template.getValidValues();
        }
    }

    public List<ValidValue> getValidValues() {
        if (this.validValues == null) {
            return null;
        }
        if (this.validValues.isEmpty()) {
            return null;
        }
        ArrayList<ValidValue> clonedList = new ArrayList<ValidValue>();
        for (ValidValue existingElement : this.validValues) {
            clonedList.add(new ValidValue(existingElement));
        }
        return clonedList;
    }

    public void setValidValues(List<ValidValue> validValues) {
        this.validValues = validValues;
    }

    @Override
    public String toString() {
        return "ValidValuesResponse{validValues=" + String.valueOf(this.validValues) + ", startingFromElement=" + this.getStartingFromElement() + ", exceptionClassName='" + this.getExceptionClassName() + "', exceptionCausedBy='" + this.getExceptionCausedBy() + "', actionDescription='" + this.getActionDescription() + "', relatedHTTPCode=" + this.getRelatedHTTPCode() + ", exceptionErrorMessage='" + this.getExceptionErrorMessage() + "', exceptionErrorMessageId='" + this.getExceptionErrorMessageId() + "', exceptionErrorMessageParameters=" + Arrays.toString(this.getExceptionErrorMessageParameters()) + ", exceptionSystemAction='" + this.getExceptionSystemAction() + "', exceptionUserAction='" + this.getExceptionUserAction() + "', exceptionProperties=" + String.valueOf(this.getExceptionProperties()) + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || ((Object)((Object)this)).getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ValidValuesResponse that = (ValidValuesResponse)((Object)objectToCompare);
        return Objects.equals(this.getValidValues(), that.getValidValues());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getValidValues());
    }
}

