/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.ConnectedAssetRelatedAssetProperties;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.ConnectedAssetUniverse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.RelatedAssetsResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetPropertyBase;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetRelatedAsset;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetRelatedAssets;
import org.odpi.openmetadata.frameworks.connectors.properties.RelatedAssetProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.RelatedAsset;

public class ConnectedAssetRelatedAssets
extends AssetRelatedAssets {
    private String serviceName;
    private String serverName;
    private String userId;
    private String omasServerURL;
    private String assetGUID;
    private ConnectedAssetUniverse connectedAsset;
    private OCFRESTClient restClient;

    ConnectedAssetRelatedAssets(String serviceName, String serverName, String userId, String omasServerURL, String assetGUID, ConnectedAssetUniverse parentAsset, int totalElementCount, int maxCacheSize, OCFRESTClient restClient) {
        super((AssetDescriptor)parentAsset, totalElementCount, maxCacheSize);
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.userId = userId;
        this.omasServerURL = omasServerURL;
        this.assetGUID = assetGUID;
        this.connectedAsset = parentAsset;
        this.restClient = restClient;
    }

    private ConnectedAssetRelatedAssets(ConnectedAssetUniverse parentAsset, ConnectedAssetRelatedAssets template) {
        super((AssetDescriptor)parentAsset, (AssetRelatedAssets)template);
        if (template != null) {
            this.serviceName = template.serviceName;
            this.serverName = template.serverName;
            this.userId = template.userId;
            this.omasServerURL = template.omasServerURL;
            this.assetGUID = template.assetGUID;
            this.connectedAsset = parentAsset;
            this.restClient = template.restClient;
        }
    }

    protected AssetRelatedAssets cloneIterator(AssetDescriptor parentAsset) {
        return new ConnectedAssetRelatedAssets(this.connectedAsset, this);
    }

    protected AssetPropertyBase cloneElement(AssetDescriptor parentAsset, AssetPropertyBase template) {
        return new AssetRelatedAsset(parentAsset, (AssetRelatedAsset)template);
    }

    protected List<AssetPropertyBase> getCachedList(int cacheStartPointer, int maximumSize) throws PropertyServerException {
        String methodName = "AssetRelatedAssets.getCachedList";
        String urlTemplate = "/servers/{0}/open-metadata/common-services/{1}/connected-asset/users/{2}/assets/{3}/related-assets?elementStart={4}&maxElements={5}";
        RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
        try {
            RelatedAssetsResponse restResult = this.restClient.callRelatedAssetsGetRESTCall("AssetRelatedAssets.getCachedList", this.omasServerURL + "/servers/{0}/open-metadata/common-services/{1}/connected-asset/users/{2}/assets/{3}/related-assets?elementStart={4}&maxElements={5}", this.serverName, this.serviceName, this.userId, this.assetGUID, cacheStartPointer, maximumSize);
            restExceptionHandler.detectAndThrowInvalidParameterException("AssetRelatedAssets.getCachedList", (FFDCResponseBase)restResult);
            restExceptionHandler.detectAndThrowUserNotAuthorizedException("AssetRelatedAssets.getCachedList", (FFDCResponseBase)restResult);
            restExceptionHandler.detectAndThrowPropertyServerException("AssetRelatedAssets.getCachedList", (FFDCResponseBase)restResult);
            List beans = restResult.getList();
            if (beans == null || beans.isEmpty()) {
                return null;
            }
            ArrayList<AssetPropertyBase> resultList = new ArrayList<AssetPropertyBase>();
            for (RelatedAsset bean : beans) {
                if (bean == null) continue;
                resultList.add((AssetPropertyBase)new AssetRelatedAsset((AssetDescriptor)this.connectedAsset, bean.getRelatedAsset(), bean.getTypeName(), bean.getAttributeName(), (RelatedAssetProperties)new ConnectedAssetRelatedAssetProperties(this.serviceName, this.serverName, this.userId, this.omasServerURL, this.assetGUID, this.restClient)));
            }
            return resultList;
        }
        catch (Throwable error) {
            restExceptionHandler.handleUnexpectedException(error, "AssetRelatedAssets.getCachedList", this.serverName, this.omasServerURL);
            return null;
        }
    }
}

