/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client;

import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.ConnectedAssetUniverse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.RelatedAssetProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectedAssetRelatedAssetProperties
extends RelatedAssetProperties {
    private String serviceName;
    private String serverName;
    private String userId = null;
    private String omasServerURL = null;
    private String assetGUID = null;
    private OCFRESTClient restClient;
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final Logger log = LoggerFactory.getLogger(ConnectedAssetRelatedAssetProperties.class);

    public ConnectedAssetRelatedAssetProperties(String serviceName, String serverName, String userId, String omasServerURL, String assetGUID, OCFRESTClient restClient) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.userId = userId;
        this.omasServerURL = omasServerURL;
        this.assetGUID = assetGUID;
        this.restClient = restClient;
    }

    public ConnectedAssetRelatedAssetProperties(ConnectedAssetRelatedAssetProperties template) {
        super((RelatedAssetProperties)template);
        if (template != null) {
            this.serviceName = template.serviceName;
            this.serverName = template.serverName;
            this.userId = template.userId;
            this.omasServerURL = template.omasServerURL;
            this.assetGUID = template.assetGUID;
            this.restClient = template.restClient;
        }
    }

    public void refresh() throws PropertyServerException, UserNotAuthorizedException {
        String methodName = "refresh";
        String serviceName = "ConnectedAssetRelatedAssetProperties";
        log.debug("Calling method: refresh");
        try {
            this.assetProperties = new ConnectedAssetUniverse("ConnectedAssetRelatedAssetProperties", this.serverName, this.omasServerURL, this.userId, this.assetGUID, this.restClient);
        }
        catch (UserNotAuthorizedException error) {
            throw error;
        }
        catch (Throwable error) {
            this.restExceptionHandler.handleUnexpectedException(error, "refresh", this.serverName, this.omasServerURL);
        }
        log.debug("Returning from method: refresh having retrieved: " + this.assetProperties.toString());
    }

    public String toString() {
        return "ConnectedAssetRelatedAssetProperties{userId='" + this.userId + '\'' + ", omasServerURL='" + this.omasServerURL + '\'' + ", assetGUID='" + this.assetGUID + '\'' + ", extendedProperties=" + this.assetProperties + '}';
    }
}

