/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.ConnectedAssetUniverse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.SchemaAttributesResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetPropertyBase;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetSchemaAttribute;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetSchemaAttributes;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetSchemaLink;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttribute;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaLink;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType;

public class ConnectedAssetSchemaAttributes
extends AssetSchemaAttributes {
    private String serviceName;
    private String serverName;
    private String userId;
    private String omasServerURL;
    private String schemaGUID;
    private ConnectedAssetUniverse connectedAsset;
    private int maxCacheSize;
    private OCFRESTClient restClient;
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    ConnectedAssetSchemaAttributes(String serviceName, String serverName, String userId, String omasServerURL, String schemaGUID, ConnectedAssetUniverse parentAsset, int totalElementCount, int maxCacheSize, OCFRESTClient restClient) {
        super((AssetDescriptor)parentAsset, totalElementCount, maxCacheSize);
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.userId = userId;
        this.omasServerURL = omasServerURL;
        this.schemaGUID = schemaGUID;
        this.connectedAsset = parentAsset;
        this.maxCacheSize = maxCacheSize;
        this.restClient = restClient;
    }

    private ConnectedAssetSchemaAttributes(ConnectedAssetUniverse parentAsset, ConnectedAssetSchemaAttributes template) {
        super((AssetDescriptor)parentAsset, (AssetSchemaAttributes)template);
        if (template != null) {
            this.serviceName = template.serviceName;
            this.serverName = template.serverName;
            this.userId = template.userId;
            this.omasServerURL = template.omasServerURL;
            this.schemaGUID = template.schemaGUID;
            this.connectedAsset = parentAsset;
            this.maxCacheSize = template.maxCacheSize;
            this.restClient = template.restClient;
        }
    }

    protected AssetSchemaAttributes cloneIterator(AssetDescriptor parentAsset) {
        return new ConnectedAssetSchemaAttributes(this.connectedAsset, this);
    }

    protected AssetPropertyBase cloneElement(AssetDescriptor parentAsset, AssetPropertyBase template) {
        return new AssetSchemaAttribute(parentAsset, (AssetSchemaAttribute)template);
    }

    protected List<AssetPropertyBase> getCachedList(int cacheStartPointer, int maximumSize) throws PropertyServerException {
        String methodName = "SchemaAttributes.getCachedList";
        String urlTemplate = "/servers/{0}/open-metadata/common-services/{1}/connected-asset/users/{2}/schemas/{3}/attributes?elementStart={4}&maxElements={5}";
        try {
            SchemaAttributesResponse restResult = this.restClient.callSchemaAttributesGetRESTCall("SchemaAttributes.getCachedList", this.omasServerURL + "/servers/{0}/open-metadata/common-services/{1}/connected-asset/users/{2}/schemas/{3}/attributes?elementStart={4}&maxElements={5}", this.serverName, this.serviceName, this.userId, this.schemaGUID, cacheStartPointer, maximumSize);
            this.restExceptionHandler.detectAndThrowInvalidParameterException("SchemaAttributes.getCachedList", (FFDCResponseBase)restResult);
            this.restExceptionHandler.detectAndThrowUserNotAuthorizedException("SchemaAttributes.getCachedList", (FFDCResponseBase)restResult);
            this.restExceptionHandler.detectAndThrowPropertyServerException("SchemaAttributes.getCachedList", (FFDCResponseBase)restResult);
            List schemaAttributes = restResult.getList();
            if (schemaAttributes == null || schemaAttributes.isEmpty()) {
                return null;
            }
            ArrayList<AssetPropertyBase> resultList = new ArrayList<AssetPropertyBase>();
            for (SchemaAttribute schemaAttribute : schemaAttributes) {
                if (schemaAttribute == null) continue;
                SchemaType schemaTypeBean = schemaAttribute.getAttributeType();
                SchemaLink schemaLinkBean = schemaAttribute.getExternalAttributeType();
                if (schemaTypeBean != null) {
                    AssetSchemaType assetSchemaType = this.connectedAsset.getAssetSchemaType(this.serviceName, this.serverName, this.omasServerURL, this.userId, schemaTypeBean, this.restClient);
                    resultList.add((AssetPropertyBase)new AssetSchemaAttribute((AssetDescriptor)this.connectedAsset, schemaAttribute, assetSchemaType));
                    continue;
                }
                if (schemaLinkBean == null) continue;
                resultList.add((AssetPropertyBase)new AssetSchemaAttribute((AssetDescriptor)this.connectedAsset, schemaAttribute, new AssetSchemaLink(schemaLinkBean)));
            }
            if (!resultList.isEmpty()) {
                return resultList;
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.handleUnexpectedException(error, "SchemaAttributes.getCachedList", this.serverName, this.omasServerURL);
        }
        return null;
    }
}

