/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.ConnectedAssetUniverse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ConnectionsResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetConnections;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetPropertyBase;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;

public class ConnectedAssetConnections
extends AssetConnections {
    private static final long serialVersionUID = 1L;
    private String serviceName;
    private String serverName;
    private String userId;
    private String omasServerURL;
    private String assetGUID;
    private ConnectedAssetUniverse connectedAsset;
    private OCFRESTClient restClient;

    ConnectedAssetConnections(String serviceName, String serverName, String userId, String omasServerURL, String assetGUID, ConnectedAssetUniverse parentAsset, int totalElementCount, int maxCacheSize, OCFRESTClient restClient) {
        super((AssetDescriptor)parentAsset, totalElementCount, maxCacheSize);
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.userId = userId;
        this.omasServerURL = omasServerURL;
        this.assetGUID = assetGUID;
        this.connectedAsset = parentAsset;
        this.restClient = restClient;
    }

    private ConnectedAssetConnections(ConnectedAssetUniverse parentAsset, ConnectedAssetConnections template) {
        super((AssetDescriptor)parentAsset, (AssetConnections)template);
        if (template != null) {
            this.serviceName = template.serviceName;
            this.serverName = template.serverName;
            this.userId = template.userId;
            this.omasServerURL = template.omasServerURL;
            this.assetGUID = template.assetGUID;
            this.connectedAsset = parentAsset;
            this.restClient = template.restClient;
        }
    }

    protected AssetConnections cloneIterator(AssetDescriptor parentAsset) {
        return new ConnectedAssetConnections(this.connectedAsset, this);
    }

    protected AssetPropertyBase cloneElement(AssetDescriptor parentAsset, AssetPropertyBase template) {
        return new ConnectionProperties(parentAsset, (ConnectionProperties)template);
    }

    protected List<AssetPropertyBase> getCachedList(int cacheStartPointer, int maximumSize) throws PropertyServerException {
        String methodName = "AssetConnections.getCachedList";
        String urlTemplate = "/servers/{0}/open-metadata/common-services/{1}/connected-asset/users/{2}/assets/{3}/connections?elementStart={4}&maxElements={5}";
        RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
        try {
            ConnectionsResponse restResult = this.restClient.callConnectionsGetRESTCall("AssetConnections.getCachedList", this.omasServerURL + "/servers/{0}/open-metadata/common-services/{1}/connected-asset/users/{2}/assets/{3}/connections?elementStart={4}&maxElements={5}", this.serverName, this.serviceName, this.userId, this.assetGUID, cacheStartPointer, maximumSize);
            restExceptionHandler.detectAndThrowInvalidParameterException((FFDCResponseBase)restResult);
            restExceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponseBase)restResult);
            restExceptionHandler.detectAndThrowPropertyServerException((FFDCResponseBase)restResult);
            List beans = restResult.getList();
            if (beans == null || beans.isEmpty()) {
                return null;
            }
            ArrayList<AssetPropertyBase> resultList = new ArrayList<AssetPropertyBase>();
            for (Connection bean : beans) {
                if (bean == null) continue;
                resultList.add((AssetPropertyBase)new ConnectionProperties((AssetDescriptor)this.connectedAsset, bean));
            }
            return resultList;
        }
        catch (Throwable error) {
            restExceptionHandler.handleUnexpectedException(error, "AssetConnections.getCachedList", this.serverName, this.omasServerURL);
            return null;
        }
    }
}

