/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.ConnectedAssetUniverse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.NotesResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetNote;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetNotes;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetPropertyBase;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Note;

public class ConnectedAssetNotes
extends AssetNotes {
    private static final long serialVersionUID = 1L;
    private String serviceName;
    private String serverName;
    private String userId;
    private String omasServerURL;
    private String noteLogGUID;
    private ConnectedAssetUniverse connectedAsset;
    private OCFRESTClient restClient;

    ConnectedAssetNotes(String serviceName, String serverName, String userId, String omasServerURL, String noteLogGUID, ConnectedAssetUniverse parentAsset, int totalElementCount, int maxCacheSize, OCFRESTClient restClient) {
        super((AssetDescriptor)parentAsset, totalElementCount, maxCacheSize);
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.userId = userId;
        this.omasServerURL = omasServerURL;
        this.noteLogGUID = noteLogGUID;
        this.connectedAsset = parentAsset;
        this.restClient = restClient;
    }

    private ConnectedAssetNotes(ConnectedAssetUniverse parentAsset, ConnectedAssetNotes template) {
        super((AssetDescriptor)parentAsset, (AssetNotes)template);
        if (template != null) {
            this.serviceName = template.serviceName;
            this.serverName = template.serverName;
            this.userId = template.userId;
            this.omasServerURL = template.omasServerURL;
            this.noteLogGUID = template.noteLogGUID;
            this.connectedAsset = parentAsset;
            this.restClient = template.restClient;
        }
    }

    protected AssetNotes cloneIterator(AssetDescriptor parentAsset) {
        return new ConnectedAssetNotes(this.connectedAsset, this);
    }

    protected AssetPropertyBase cloneElement(AssetDescriptor parentAsset, AssetPropertyBase template) {
        return new AssetNote(parentAsset, (AssetNote)template);
    }

    protected List<AssetPropertyBase> getCachedList(int cacheStartPointer, int maximumSize) throws PropertyServerException {
        String methodName = "AssetNotes.getCachedList";
        String urlTemplate = "/servers/{0}/open-metadata/common-services/{1}/connected-asset/users/{2}/note-logs/{3}/notes?elementStart={4}&maxElements={5}";
        RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
        try {
            NotesResponse restResult = this.restClient.callNotesGetRESTCall("AssetNotes.getCachedList", this.omasServerURL + "/servers/{0}/open-metadata/common-services/{1}/connected-asset/users/{2}/note-logs/{3}/notes?elementStart={4}&maxElements={5}", this.serverName, this.serviceName, this.userId, this.noteLogGUID, cacheStartPointer, maximumSize);
            restExceptionHandler.detectAndThrowInvalidParameterException((FFDCResponse)restResult);
            restExceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponse)restResult);
            restExceptionHandler.detectAndThrowPropertyServerException((FFDCResponse)restResult);
            List beans = restResult.getList();
            if (beans == null || beans.isEmpty()) {
                return null;
            }
            ArrayList<AssetPropertyBase> resultList = new ArrayList<AssetPropertyBase>();
            for (Note bean : beans) {
                if (bean == null) continue;
                resultList.add((AssetPropertyBase)new AssetNote((AssetDescriptor)this.connectedAsset, bean));
            }
            return resultList;
        }
        catch (Throwable error) {
            restExceptionHandler.handleUnexpectedException(error, "AssetNotes.getCachedList", this.serverName, this.omasServerURL);
            return null;
        }
    }
}

