/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.ConnectedAssetUniverse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.InformalTagsResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetInformalTag;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetInformalTags;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetPropertyBase;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.InformalTag;

public class ConnectedAssetInformalTags
extends AssetInformalTags {
    private static final long serialVersionUID = 1L;
    private String serviceName;
    private String serverName;
    private String userId;
    private String omasServerURL;
    private String assetGUID;
    private ConnectedAssetUniverse connectedAsset;
    private OCFRESTClient restClient;

    ConnectedAssetInformalTags(String serviceName, String serverName, String userId, String omasServerURL, String assetGUID, ConnectedAssetUniverse parentAsset, int totalElementCount, int maxCacheSize, OCFRESTClient restClient) {
        super((AssetDescriptor)parentAsset, totalElementCount, maxCacheSize);
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.userId = userId;
        this.omasServerURL = omasServerURL;
        this.assetGUID = assetGUID;
        this.connectedAsset = parentAsset;
        this.restClient = restClient;
    }

    private ConnectedAssetInformalTags(ConnectedAssetUniverse parentAsset, ConnectedAssetInformalTags template) {
        super((AssetDescriptor)parentAsset, (AssetInformalTags)template);
        if (template != null) {
            this.serviceName = template.serviceName;
            this.serverName = template.serverName;
            this.userId = template.userId;
            this.omasServerURL = template.omasServerURL;
            this.assetGUID = template.assetGUID;
            this.connectedAsset = parentAsset;
            this.restClient = template.restClient;
        }
    }

    protected AssetInformalTags cloneIterator(AssetDescriptor parentAsset) {
        return new ConnectedAssetInformalTags(this.connectedAsset, this);
    }

    protected AssetPropertyBase cloneElement(AssetDescriptor parentAsset, AssetPropertyBase template) {
        return new AssetInformalTag(parentAsset, (AssetInformalTag)template);
    }

    protected List<AssetPropertyBase> getCachedList(int cacheStartPointer, int maximumSize) throws PropertyServerException {
        String methodName = "AssetInformalTags.getCachedList";
        String urlTemplate = "/servers/{0}/open-metadata/common-services/{1}/connected-asset/users/{2}/assets/{3}/informal-tags?elementStart={4}&maxElements={5}";
        RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
        try {
            InformalTagsResponse restResult = this.restClient.callOCFInformalTagsGetRESTCall("AssetInformalTags.getCachedList", this.omasServerURL + "/servers/{0}/open-metadata/common-services/{1}/connected-asset/users/{2}/assets/{3}/informal-tags?elementStart={4}&maxElements={5}", this.serverName, this.serviceName, this.userId, this.assetGUID, cacheStartPointer, maximumSize);
            restExceptionHandler.detectAndThrowInvalidParameterException((FFDCResponse)restResult);
            restExceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponse)restResult);
            restExceptionHandler.detectAndThrowPropertyServerException((FFDCResponse)restResult);
            List beans = restResult.getList();
            if (beans == null || beans.isEmpty()) {
                return null;
            }
            ArrayList<AssetPropertyBase> resultList = new ArrayList<AssetPropertyBase>();
            for (InformalTag bean : beans) {
                if (bean == null) continue;
                resultList.add((AssetPropertyBase)new AssetInformalTag((AssetDescriptor)this.connectedAsset, bean));
            }
            return resultList;
        }
        catch (Exception error) {
            restExceptionHandler.handleUnexpectedException((Throwable)error, "AssetInformalTags.getCachedList", this.serverName, this.omasServerURL);
            return null;
        }
    }
}

