/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.ConnectedAssetUniverse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.RelatedMediaReferencesResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetPropertyBase;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetRelatedMediaReference;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetRelatedMediaReferences;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.RelatedMediaReference;

public class ConnectedAssetRelatedMediaReferences
extends AssetRelatedMediaReferences {
    private static final long serialVersionUID = 1L;
    private String serviceName;
    private String serverName;
    private String userId;
    private String omasServerURL;
    private String assetGUID;
    private ConnectedAssetUniverse connectedAsset;
    private OCFRESTClient restClient;
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    ConnectedAssetRelatedMediaReferences(String serviceName, String serverName, String userId, String omasServerURL, String assetGUID, ConnectedAssetUniverse parentAsset, int totalElementCount, int maxCacheSize, OCFRESTClient restClient) {
        super((AssetDescriptor)parentAsset, totalElementCount, maxCacheSize);
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.userId = userId;
        this.omasServerURL = omasServerURL;
        this.assetGUID = assetGUID;
        this.connectedAsset = parentAsset;
        this.restClient = restClient;
    }

    private ConnectedAssetRelatedMediaReferences(ConnectedAssetUniverse parentAsset, ConnectedAssetRelatedMediaReferences template) {
        super((AssetDescriptor)parentAsset, (AssetRelatedMediaReferences)template);
        if (template != null) {
            this.serviceName = template.serviceName;
            this.serverName = template.serverName;
            this.userId = template.userId;
            this.omasServerURL = template.omasServerURL;
            this.assetGUID = template.assetGUID;
            this.connectedAsset = parentAsset;
            this.restClient = template.restClient;
        }
    }

    protected AssetRelatedMediaReferences cloneIterator(AssetDescriptor parentAsset) {
        return new ConnectedAssetRelatedMediaReferences(this.connectedAsset, this);
    }

    protected AssetPropertyBase cloneElement(AssetDescriptor parentAsset, AssetPropertyBase template) {
        return new AssetRelatedMediaReference(parentAsset, (AssetRelatedMediaReference)template);
    }

    protected List<AssetPropertyBase> getCachedList(int cacheStartPointer, int maximumSize) throws PropertyServerException {
        String methodName = "AssetRelatedMediaReferences.getCachedList";
        String urlTemplate = "/servers/{0}/open-metadata/common-services/{1}/connected-asset/users/{2}/assets/{3}/related-media-references?elementStart={4}&maxElements={5}";
        try {
            RelatedMediaReferencesResponse restResult = this.restClient.callOCFRelatedMediaReferencesGetRESTCall("AssetRelatedMediaReferences.getCachedList", this.omasServerURL + "/servers/{0}/open-metadata/common-services/{1}/connected-asset/users/{2}/assets/{3}/related-media-references?elementStart={4}&maxElements={5}", this.serverName, this.serviceName, this.userId, this.assetGUID, cacheStartPointer, maximumSize);
            this.restExceptionHandler.detectAndThrowInvalidParameterException((FFDCResponse)restResult);
            this.restExceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponse)restResult);
            this.restExceptionHandler.detectAndThrowPropertyServerException((FFDCResponse)restResult);
            List beans = restResult.getList();
            if (beans == null || beans.isEmpty()) {
                return null;
            }
            ArrayList<AssetPropertyBase> resultList = new ArrayList<AssetPropertyBase>();
            for (RelatedMediaReference bean : beans) {
                if (bean == null) continue;
                resultList.add((AssetPropertyBase)new AssetRelatedMediaReference((AssetDescriptor)this.connectedAsset, bean));
            }
            return resultList;
        }
        catch (Exception error) {
            this.restExceptionHandler.handleUnexpectedException((Throwable)error, "AssetRelatedMediaReferences.getCachedList", this.serverName, this.omasServerURL);
            return null;
        }
    }
}

