/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.NotesResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.Notes;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementBase;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Note;

public class ConnectedNotes
extends Notes {
    private static final long serialVersionUID = 1L;
    private String serviceName;
    private String serverName;
    private String userId;
    private String omasServerURL;
    private String noteLogGUID;
    private OCFRESTClient restClient;

    ConnectedNotes(String serviceName, String serverName, String userId, String omasServerURL, String noteLogGUID, int totalElementCount, int maxCacheSize, OCFRESTClient restClient) {
        super(totalElementCount, maxCacheSize);
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.userId = userId;
        this.omasServerURL = omasServerURL;
        this.noteLogGUID = noteLogGUID;
        this.restClient = restClient;
    }

    private ConnectedNotes(ConnectedNotes template) {
        super((Notes)template);
        if (template != null) {
            this.serviceName = template.serviceName;
            this.serverName = template.serverName;
            this.userId = template.userId;
            this.omasServerURL = template.omasServerURL;
            this.noteLogGUID = template.noteLogGUID;
            this.restClient = template.restClient;
        }
    }

    protected Notes cloneIterator() {
        return new ConnectedNotes(this);
    }

    protected List<ElementBase> getCachedList(int cacheStartPointer, int maximumSize) throws PropertyServerException {
        String methodName = "Notes.getCachedList";
        String urlTemplate = "/servers/{0}/open-metadata/common-services/{1}/connected-asset/users/{2}/note-logs/{3}/notes?elementStart={4}&maxElements={5}";
        RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
        try {
            NotesResponse restResult = this.restClient.callOCFNotesGetRESTCall("Notes.getCachedList", this.omasServerURL + "/servers/{0}/open-metadata/common-services/{1}/connected-asset/users/{2}/note-logs/{3}/notes?elementStart={4}&maxElements={5}", this.serverName, this.serviceName, this.userId, this.noteLogGUID, cacheStartPointer, maximumSize);
            restExceptionHandler.detectAndThrowInvalidParameterException((FFDCResponse)restResult);
            restExceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponse)restResult);
            restExceptionHandler.detectAndThrowPropertyServerException((FFDCResponse)restResult);
            List beans = restResult.getList();
            if (beans == null || beans.isEmpty()) {
                return null;
            }
            ArrayList<ElementBase> resultList = new ArrayList<ElementBase>();
            for (Note bean : beans) {
                if (bean == null) continue;
                resultList.add((ElementBase)bean);
            }
            return resultList;
        }
        catch (Exception error) {
            restExceptionHandler.handleUnexpectedException((Throwable)error, "Notes.getCachedList", this.serverName, this.omasServerURL);
            return null;
        }
    }
}

