/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client;

import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.ConnectedAssetUniverse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectedAssetProperties
extends org.odpi.openmetadata.frameworks.connectors.properties.ConnectedAssetProperties {
    private static final long serialVersionUID = 1L;
    private String serviceName;
    private String remoteServerName;
    private String userId = null;
    private String localServerUserId = null;
    private String localServerPassword = null;
    private String omasServerURL = null;
    private String connectorInstanceId = null;
    private ConnectionProperties connection = null;
    private String assetGUID = null;
    private static final Logger log = LoggerFactory.getLogger(ConnectedAssetProperties.class);

    public ConnectedAssetProperties(String serviceName, String remoteServerName, String userId, String omasServerURL, String connectorInstanceId, ConnectionProperties connection, String assetGUID) {
        this.serviceName = serviceName;
        this.remoteServerName = remoteServerName;
        this.userId = userId;
        this.omasServerURL = omasServerURL;
        this.connectorInstanceId = connectorInstanceId;
        this.connection = connection;
        this.assetGUID = assetGUID;
    }

    public ConnectedAssetProperties(String serviceName, String remoteServerName, String localServerUserId, String localServerPassword, String userId, String omasServerURL, String connectorInstanceId, ConnectionProperties connection, String assetGUID) {
        this.serviceName = serviceName;
        this.remoteServerName = remoteServerName;
        this.localServerUserId = localServerUserId;
        this.localServerPassword = localServerPassword;
        this.userId = userId;
        this.omasServerURL = omasServerURL;
        this.connectorInstanceId = connectorInstanceId;
        this.connection = connection;
        this.assetGUID = assetGUID;
    }

    public ConnectedAssetProperties(ConnectedAssetProperties template) {
        super((org.odpi.openmetadata.frameworks.connectors.properties.ConnectedAssetProperties)template);
        if (template != null) {
            this.serviceName = template.serviceName;
            this.remoteServerName = template.remoteServerName;
            this.localServerUserId = template.localServerUserId;
            this.localServerPassword = template.localServerPassword;
            this.userId = template.userId;
            this.connection = template.connection;
            this.connectorInstanceId = template.connectorInstanceId;
            this.omasServerURL = template.omasServerURL;
            this.assetGUID = template.assetGUID;
        }
    }

    public void refresh() throws PropertyServerException, UserNotAuthorizedException {
        String methodName = "refresh";
        log.debug("Calling method: refresh");
        RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
        try {
            this.assetProperties = this.localServerUserId != null && this.localServerPassword != null ? new ConnectedAssetUniverse(this.serviceName, this.remoteServerName, this.localServerUserId, this.localServerPassword, this.omasServerURL, this.userId, this.assetGUID, this.connection.getGUID()) : new ConnectedAssetUniverse(this.serviceName, this.remoteServerName, this.omasServerURL, this.userId, this.assetGUID, this.connection.getGUID());
        }
        catch (UserNotAuthorizedException error) {
            throw error;
        }
        catch (Throwable error) {
            restExceptionHandler.handleUnexpectedException(error, "refresh", this.remoteServerName, this.omasServerURL);
        }
        log.debug("Returning from method: refresh having retrieved: " + this.assetProperties.toString());
    }

    public String toString() {
        return "ConnectedAssetProperties{serviceName='" + this.serviceName + "', remoteServerName='" + this.remoteServerName + "', userId='" + this.userId + "', localServerUserId='" + this.localServerUserId + "', omasServerURL='" + this.omasServerURL + "', connectorInstanceId='" + this.connectorInstanceId + "', connection=" + this.connection + ", assetGUID='" + this.assetGUID + "', extendedProperties=" + this.assetProperties + "}";
    }
}

