/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client;

import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.ConnectedAssetProperties;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.ConnectedAssetUniverse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.ffdc.OMAGOCFErrorCode;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.AssetResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ConnectionResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetUniverse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Asset;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;

public class ConnectedAssetClientBase {
    protected String serverName;
    protected String serverPlatformURLRoot;
    protected AuditLog auditLog;
    protected InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    protected static NullRequestBody nullRequestBody = new NullRequestBody();

    public ConnectedAssetClientBase(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.auditLog = auditLog;
    }

    public ConnectedAssetClientBase(String serverName, String serverPlatformURLRoot, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.auditLog = auditLog;
    }

    public ConnectedAssetClientBase(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        this(serverName, serverPlatformURLRoot, null);
    }

    protected Asset getAssetSummary(OCFRESTClient restClient, String serviceName, String userId, String guid, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String urlTemplate = "/servers/{0}/open-metadata/common-services/{1}/connected-asset/users/{2}/assets/{3}";
        AssetResponse restResult = restClient.callAssetGetRESTCall(methodName, this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/connected-asset/users/{2}/assets/{3}", this.serverName, serviceName, userId, guid);
        return restResult.getAsset();
    }

    protected AssetUniverse getAssetProperties(String serviceName, String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getAssetProperties";
        String guidParameter = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "getAssetProperties");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "getAssetProperties");
        try {
            return new ConnectedAssetUniverse(serviceName, this.serverName, this.serverPlatformURLRoot, userId, assetGUID);
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException error) {
            throw error;
        }
        catch (Throwable error) {
            throw new PropertyServerException(OMAGOCFErrorCode.NO_ASSET_PROPERTIES.getMessageDefinition(new String[]{assetGUID, error.getClass().getName(), error.getMessage()}), this.getClass().getName(), "getAssetProperties");
        }
    }

    protected Connector getConnectorForConnection(OCFRESTClient restClient, String serviceName, String userId, Connection requestedConnection, String methodName) throws ConnectionCheckedException, ConnectorCheckedException {
        ConnectorBroker connectorBroker = new ConnectorBroker();
        Connector newConnector = connectorBroker.getConnector(requestedConnection);
        if (newConnector == null) {
            throw new ConnectorCheckedException(OMAGOCFErrorCode.NULL_CONNECTOR_RETURNED.getMessageDefinition(new String[]{requestedConnection.getQualifiedName(), serviceName, this.serverName, this.serverPlatformURLRoot}), this.getClass().getName(), methodName);
        }
        try {
            String assetGUID = this.getAssetForConnection(restClient, serviceName, userId, requestedConnection.getGUID());
            ConnectedAssetProperties connectedAssetProperties = new ConnectedAssetProperties(serviceName, this.serverName, userId, this.serverPlatformURLRoot, newConnector.getConnectorInstanceId(), newConnector.getConnection(), assetGUID);
            newConnector.initializeConnectedAssetProperties((org.odpi.openmetadata.frameworks.connectors.properties.ConnectedAssetProperties)connectedAssetProperties);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return newConnector;
    }

    protected Connection getConnectionByGUID(OCFRESTClient restClient, String serviceName, String userId, String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getConnectionByGUID";
        String urlTemplate = "/servers/{0}/open-metadata/common-services/{1}/connected-asset/users/{2}/connections/{3}";
        ConnectionResponse restResult = restClient.callConnectionGetRESTCall("getConnectionByGUID", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/connected-asset/users/{2}/connections/{3}", this.serverName, serviceName, userId, guid);
        return restResult.getConnection();
    }

    protected Connection getConnectionByName(OCFRESTClient restClient, String serviceName, String userId, String name) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getConnectionByName";
        String urlTemplate = "/servers/{0}/open-metadata/common-services/{1}/connected-asset/users/{2}/connections/by-name/{3}";
        ConnectionResponse restResult = restClient.callConnectionGetRESTCall("getConnectionByName", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/connected-asset/users/{2}/connections/by-name/{3}", this.serverName, serviceName, userId, name);
        return restResult.getConnection();
    }

    protected Connection getConnectionForAsset(OCFRESTClient restClient, String serviceName, String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getConnectionForAsset";
        String urlTemplate = "/servers/{0}/open-metadata/common-services/{1}/connected-asset/users/{2}/assets/{3}/connection";
        ConnectionResponse restResult = restClient.callConnectionGetRESTCall("getConnectionForAsset", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/connected-asset/users/{2}/assets/{3}/connection", this.serverName, serviceName, userId, assetGUID);
        return restResult.getConnection();
    }

    protected String getAssetForConnection(OCFRESTClient restClient, String serviceName, String userId, String connectionGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getAssetForConnection";
        String urlTemplate = "/servers/{0}/open-metadata/common-services/{1}/connected-asset/users/{2}/assets/by-connection/{3}";
        GUIDResponse restResult = restClient.callGUIDGetRESTCall("getAssetForConnection", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/common-services/{1}/connected-asset/users/{2}/assets/by-connection/{3}", new Object[]{this.serverName, serviceName, userId, connectionGUID});
        return restResult.getGUID();
    }
}

