/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.ConnectedAssetUniverse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.CommentResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.CommentsResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetComment;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetCommentReplies;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetPropertyBase;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Comment;

public class ConnectedAssetCommentReplies
extends AssetCommentReplies {
    private static final long serialVersionUID = 1L;
    private String serviceName;
    private String serverName;
    private String userId;
    private String omasServerURL;
    private String rootCommentGUID;
    private ConnectedAssetUniverse connectedAsset;
    private int maxCacheSize;
    private OCFRESTClient restClient;

    ConnectedAssetCommentReplies(String serviceName, String serverName, String userId, String omasServerURL, String rootCommentGUID, ConnectedAssetUniverse parentAsset, int totalElementCount, int maxCacheSize, OCFRESTClient restClient) {
        super((AssetDescriptor)parentAsset, totalElementCount, maxCacheSize);
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.userId = userId;
        this.omasServerURL = omasServerURL;
        this.rootCommentGUID = rootCommentGUID;
        this.connectedAsset = parentAsset;
        this.maxCacheSize = maxCacheSize;
        this.restClient = restClient;
    }

    private ConnectedAssetCommentReplies(ConnectedAssetUniverse parentAsset, ConnectedAssetCommentReplies template) {
        super((AssetDescriptor)parentAsset, (AssetCommentReplies)template);
        if (template != null) {
            this.serviceName = template.serviceName;
            this.serverName = template.serverName;
            this.userId = template.userId;
            this.omasServerURL = template.omasServerURL;
            this.rootCommentGUID = template.rootCommentGUID;
            this.connectedAsset = parentAsset;
            this.maxCacheSize = template.maxCacheSize;
            this.restClient = template.restClient;
        }
    }

    protected AssetCommentReplies cloneIterator(AssetDescriptor parentAsset) {
        return new ConnectedAssetCommentReplies(this.connectedAsset, this);
    }

    protected AssetPropertyBase cloneElement(AssetDescriptor parentAsset, AssetPropertyBase template) {
        return new AssetComment(parentAsset, (AssetComment)template);
    }

    protected List<AssetPropertyBase> getCachedList(int cacheStartPointer, int maximumSize) throws PropertyServerException {
        String methodName = "AssetCommentReplies.getCachedList";
        String urlTemplate = "/servers/{0}/open-metadata/common-services/{1}/connected-asset/users/{2}/assets/{3}/comments?elementStart={4}&maxElements={5}";
        RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
        try {
            CommentsResponse restResult = this.restClient.callOCFCommentsGetRESTCall("AssetCommentReplies.getCachedList", this.omasServerURL + "/servers/{0}/open-metadata/common-services/{1}/connected-asset/users/{2}/assets/{3}/comments?elementStart={4}&maxElements={5}", this.serverName, this.serviceName, this.userId, this.rootCommentGUID, cacheStartPointer, maximumSize);
            restExceptionHandler.detectAndThrowInvalidParameterException((FFDCResponse)restResult);
            restExceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponse)restResult);
            restExceptionHandler.detectAndThrowPropertyServerException((FFDCResponse)restResult);
            List Responses = restResult.getList();
            if (Responses == null || Responses.isEmpty()) {
                return null;
            }
            ArrayList<AssetPropertyBase> resultList = new ArrayList<AssetPropertyBase>();
            for (CommentResponse commentResponse : Responses) {
                if (commentResponse == null) continue;
                Comment bean = commentResponse.getComment();
                ConnectedAssetCommentReplies commentReplies = null;
                if (commentResponse.getReplyCount() > 0) {
                    commentReplies = new ConnectedAssetCommentReplies(this.serviceName, this.serverName, this.userId, this.omasServerURL, bean.getGUID(), this.connectedAsset, commentResponse.getReplyCount(), this.maxCacheSize, this.restClient);
                }
                resultList.add((AssetPropertyBase)new AssetComment((AssetDescriptor)this.connectedAsset, bean, commentReplies));
            }
            return resultList;
        }
        catch (Exception error) {
            restExceptionHandler.handleUnexpectedException((Throwable)error, "AssetCommentReplies.getCachedList", this.serverName, this.omasServerURL);
            return null;
        }
    }
}

