/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client;

import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.ConnectedAssetCertifications;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.ConnectedAssetComplexSchemaType;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.ConnectedAssetConnections;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.ConnectedAssetExternalIdentifiers;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.ConnectedAssetExternalReferences;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.ConnectedAssetFeedback;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.ConnectedAssetLicenses;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.ConnectedAssetLineage;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.ConnectedAssetLocations;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.ConnectedAssetNoteLogs;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.ConnectedAssetRelatedAssets;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.ConnectedAssetRelatedMediaReferences;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.AssetResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetUniverse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ComplexSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType;

public class ConnectedAssetUniverse
extends AssetUniverse {
    private static final long serialVersionUID = 1L;
    private final int MAX_CACHE_SIZE = 100;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public ConnectedAssetUniverse(String serviceName, String remoteServerName, String omasServerURL, String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        OCFRESTClient restClient = new OCFRESTClient(remoteServerName, omasServerURL);
        AssetResponse assetResponse = this.getAssetSummary(serviceName, remoteServerName, omasServerURL, restClient, userId, assetGUID);
        this.processAssetResponse(serviceName, remoteServerName, omasServerURL, userId, assetGUID, restClient, assetResponse);
    }

    public ConnectedAssetUniverse(String serviceName, String remoteServerName, String localServerUserId, String localServerPassword, String omasServerURL, String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        OCFRESTClient restClient = new OCFRESTClient(remoteServerName, omasServerURL, localServerUserId, localServerPassword);
        AssetResponse assetResponse = this.getAssetSummary(serviceName, remoteServerName, omasServerURL, restClient, userId, assetGUID);
        this.processAssetResponse(serviceName, remoteServerName, omasServerURL, userId, assetGUID, restClient, assetResponse);
    }

    public ConnectedAssetUniverse(String serviceName, String remoteServerName, String omasServerURL, String userId, String assetGUID, OCFRESTClient restClient) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        AssetResponse assetResponse = this.getAssetSummary(serviceName, remoteServerName, omasServerURL, restClient, userId, assetGUID);
        this.processAssetResponse(serviceName, remoteServerName, omasServerURL, userId, assetGUID, restClient, assetResponse);
    }

    public ConnectedAssetUniverse(String serviceName, String remoteServerName, String omasServerURL, String userId, String assetGUID, String connectionGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        OCFRESTClient restClient = new OCFRESTClient(remoteServerName, omasServerURL);
        AssetResponse assetResponse = this.getConnectedAssetSummary(serviceName, remoteServerName, omasServerURL, restClient, userId, assetGUID, connectionGUID);
        this.processAssetResponse(serviceName, remoteServerName, omasServerURL, userId, assetGUID, restClient, assetResponse);
    }

    public ConnectedAssetUniverse(String serviceName, String remoteServerName, String localServerUserId, String localServerPassword, String omasServerURL, String userId, String assetGUID, String connectionGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        OCFRESTClient restClient = new OCFRESTClient(remoteServerName, omasServerURL, localServerUserId, localServerPassword);
        AssetResponse assetResponse = this.getConnectedAssetSummary(serviceName, remoteServerName, omasServerURL, restClient, userId, assetGUID, connectionGUID);
        this.processAssetResponse(serviceName, remoteServerName, omasServerURL, userId, assetGUID, restClient, assetResponse);
    }

    private void processAssetResponse(String serviceName, String remoteServerName, String omasServerURL, String userId, String assetGUID, OCFRESTClient restClient, AssetResponse assetResponse) {
        super.setAssetBean(assetResponse.getAsset());
        if (assetResponse.getExternalIdentifierCount() > 0) {
            this.externalIdentifiers = new ConnectedAssetExternalIdentifiers(serviceName, remoteServerName, userId, omasServerURL, assetGUID, this, assetResponse.getExternalIdentifierCount(), 100, restClient);
        }
        if (assetResponse.getRelatedMediaReferenceCount() > 0) {
            this.relatedMediaReferences = new ConnectedAssetRelatedMediaReferences(serviceName, remoteServerName, userId, omasServerURL, assetGUID, this, assetResponse.getRelatedMediaReferenceCount(), 100, restClient);
        }
        if (assetResponse.getNoteLogsCount() > 0) {
            this.noteLogs = new ConnectedAssetNoteLogs(serviceName, remoteServerName, userId, omasServerURL, assetGUID, this, assetResponse.getNoteLogsCount(), 100, restClient);
        }
        if (assetResponse.getExternalReferencesCount() > 0) {
            this.externalReferences = new ConnectedAssetExternalReferences(serviceName, remoteServerName, userId, omasServerURL, assetGUID, this, assetResponse.getExternalReferencesCount(), 100, restClient);
        }
        if (assetResponse.getConnectionCount() > 0) {
            this.connections = new ConnectedAssetConnections(serviceName, remoteServerName, userId, omasServerURL, assetGUID, this, assetResponse.getConnectionCount(), 100, restClient);
        }
        if (assetResponse.getLicenseCount() > 0) {
            this.licenses = new ConnectedAssetLicenses(serviceName, remoteServerName, userId, omasServerURL, assetGUID, this, assetResponse.getLicenseCount(), 100, restClient);
        }
        if (assetResponse.getCertificationCount() > 0) {
            this.certifications = new ConnectedAssetCertifications(serviceName, remoteServerName, userId, omasServerURL, assetGUID, this, assetResponse.getCertificationCount(), 100, restClient);
        }
        this.feedback = new ConnectedAssetFeedback(serviceName, remoteServerName, userId, omasServerURL, assetGUID, this, assetResponse.getCommentCount(), assetResponse.getLikeCount(), assetResponse.getRatingsCount(), assetResponse.getInformalTagCount(), 100, restClient);
        if (assetResponse.getKnownLocationsCount() > 0) {
            this.knownLocations = new ConnectedAssetLocations(serviceName, remoteServerName, userId, omasServerURL, assetGUID, this, assetResponse.getKnownLocationsCount(), 100, restClient);
        }
        this.lineage = new ConnectedAssetLineage(serviceName, remoteServerName, userId, omasServerURL, assetGUID, this, 100, restClient);
        if (assetResponse.getRelatedAssetCount() > 0) {
            this.relatedAssets = new ConnectedAssetRelatedAssets(serviceName, remoteServerName, userId, omasServerURL, assetGUID, this, assetResponse.getRelatedAssetCount(), 100, restClient);
        }
        if (assetResponse.getSchemaType() != null) {
            this.schema = this.getAssetSchemaType(serviceName, remoteServerName, omasServerURL, userId, assetResponse.getSchemaType(), restClient);
        }
    }

    private AssetResponse getConnectedAssetSummary(String serviceName, String remoteServerName, String omasServerURL, OCFRESTClient restClient, String userId, String assetGUID, String connectionGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getConnectedAssetSummary";
        String urlTemplate = "/servers/{0}/open-metadata/common-services/{1}/connected-asset/users/{2}/assets/{3}/via-connection/{4}";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(omasServerURL, remoteServerName, "getConnectedAssetSummary");
        AssetResponse restResult = null;
        try {
            restResult = restClient.callOCFAssetGetRESTCall("getConnectedAssetSummary", omasServerURL + "/servers/{0}/open-metadata/common-services/{1}/connected-asset/users/{2}/assets/{3}/via-connection/{4}", remoteServerName, serviceName, userId, assetGUID, connectionGUID);
            this.restExceptionHandler.detectAndThrowInvalidParameterException((FFDCResponse)restResult);
            this.restExceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponse)restResult);
            this.restExceptionHandler.detectAndThrowPropertyServerException((FFDCResponse)restResult);
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException error) {
            throw error;
        }
        catch (Exception error) {
            this.restExceptionHandler.handleUnexpectedException((Throwable)error, "getConnectedAssetSummary", remoteServerName, omasServerURL);
        }
        return restResult;
    }

    private AssetResponse getAssetSummary(String serviceName, String remoteServerName, String omasServerURL, OCFRESTClient restClient, String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getAssetSummary";
        String urlTemplate = "/servers/{0}/open-metadata/common-services/{1}/connected-asset/users/{2}/assets/{3}";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(omasServerURL, remoteServerName, "getAssetSummary");
        AssetResponse restResult = null;
        try {
            restResult = restClient.callOCFAssetGetRESTCall("getAssetSummary", omasServerURL + "/servers/{0}/open-metadata/common-services/{1}/connected-asset/users/{2}/assets/{3}", remoteServerName, serviceName, userId, assetGUID);
            this.restExceptionHandler.detectAndThrowInvalidParameterException((FFDCResponse)restResult);
            this.restExceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponse)restResult);
            this.restExceptionHandler.detectAndThrowPropertyServerException((FFDCResponse)restResult);
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException error) {
            throw error;
        }
        catch (Exception error) {
            this.restExceptionHandler.handleUnexpectedException((Throwable)error, "getAssetSummary", remoteServerName, omasServerURL);
        }
        return restResult;
    }

    private AssetSchemaType getAssetSchemaType(String serviceName, String remoteServerName, String omasServerURL, String userId, SchemaType bean, OCFRESTClient restClient) {
        if (bean == null) {
            return null;
        }
        if (bean instanceof ComplexSchemaType) {
            return new ConnectedAssetComplexSchemaType(serviceName, remoteServerName, omasServerURL, userId, this, 100, (ComplexSchemaType)bean, restClient);
        }
        return AssetSchemaType.createAssetSchemaType((AssetDescriptor)this, (SchemaType)bean);
    }
}

