/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.CommentConversation;
import org.odpi.openmetadata.frameworks.connectors.properties.Comments;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Comment;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementBase;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.ConnectedCommentReplies;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.rest.CommentResponse;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.rest.CommentsResponse;

public class ConnectedComments
extends Comments {
    private static final long serialVersionUID = 1L;
    private String serviceName;
    private String serverName;
    private String userId;
    private String omasServerURL;
    private String assetGUID;
    private int maxCacheSize;
    private OCFRESTClient restClient;

    ConnectedComments(String serviceName, String serverName, String userId, String omasServerURL, String assetGUID, int totalElementCount, int maxCacheSize, OCFRESTClient restClient) {
        super(totalElementCount, maxCacheSize);
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.userId = userId;
        this.omasServerURL = omasServerURL;
        this.assetGUID = assetGUID;
        this.maxCacheSize = maxCacheSize;
        this.restClient = restClient;
    }

    private ConnectedComments(ConnectedComments template) {
        super((Comments)template);
        if (template != null) {
            this.serviceName = template.serviceName;
            this.serverName = template.serverName;
            this.userId = template.userId;
            this.omasServerURL = template.omasServerURL;
            this.assetGUID = template.assetGUID;
            this.maxCacheSize = template.maxCacheSize;
            this.restClient = template.restClient;
        }
    }

    protected Comments cloneIterator() {
        return new ConnectedComments(this);
    }

    protected ElementBase cloneElement(ElementBase template) {
        if (template instanceof CommentConversation) {
            return new CommentConversation((CommentConversation)template);
        }
        if (template instanceof Comment) {
            return new CommentConversation((Comment)template);
        }
        return null;
    }

    protected List<ElementBase> getCachedList(int cacheStartPointer, int maximumSize) throws PropertyServerException {
        String methodName = "Comments.getCachedList";
        String urlTemplate = "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/assets/{3}/comments?elementStart={4}&maxElements={5}";
        RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
        try {
            CommentsResponse restResult = this.restClient.callOCFCommentsGetRESTCall("Comments.getCachedList", this.omasServerURL + "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/assets/{3}/comments?elementStart={4}&maxElements={5}", this.serverName, this.serviceName, this.userId, this.assetGUID, cacheStartPointer, maximumSize);
            restExceptionHandler.detectAndThrowInvalidParameterException((FFDCResponse)restResult);
            restExceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponse)restResult);
            restExceptionHandler.detectAndThrowPropertyServerException((FFDCResponse)restResult);
            List Responses = restResult.getList();
            if (Responses == null || Responses.isEmpty()) {
                return null;
            }
            ArrayList<ElementBase> resultList = new ArrayList<ElementBase>();
            for (CommentResponse commentResponse : Responses) {
                if (commentResponse == null) continue;
                Comment bean = commentResponse.getComment();
                ConnectedCommentReplies commentReplies = null;
                if (commentResponse.getReplyCount() > 0) {
                    commentReplies = new ConnectedCommentReplies(this.serviceName, this.serverName, this.userId, this.omasServerURL, bean.getGUID(), commentResponse.getReplyCount(), this.maxCacheSize, this.restClient);
                }
                resultList.add((ElementBase)new CommentConversation(bean, commentReplies));
            }
            return resultList;
        }
        catch (Exception error) {
            restExceptionHandler.handleUnexpectedException((Throwable)error, "Comments.getCachedList", this.serverName, this.omasServerURL);
            return null;
        }
    }
}

