/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.ExternalIdentifiers;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementBase;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ExternalIdentifier;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.rest.ExternalIdentifiersResponse;

public class ConnectedExternalIdentifiers
extends ExternalIdentifiers {
    private static final long serialVersionUID = 1L;
    private String serviceName;
    private String serverName;
    private String userId;
    private String omasServerURL;
    private String assetGUID;
    private OCFRESTClient restClient;

    ConnectedExternalIdentifiers(String serviceName, String serverName, String userId, String omasServerURL, String assetGUID, int totalElementCount, int maxCacheSize, OCFRESTClient restClient) {
        super(totalElementCount, maxCacheSize);
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.userId = userId;
        this.omasServerURL = omasServerURL;
        this.assetGUID = assetGUID;
        this.restClient = restClient;
    }

    private ConnectedExternalIdentifiers(ConnectedExternalIdentifiers template) {
        super((ExternalIdentifiers)template);
        if (template != null) {
            this.serviceName = template.serviceName;
            this.serverName = template.serverName;
            this.userId = template.userId;
            this.omasServerURL = template.omasServerURL;
            this.assetGUID = template.assetGUID;
            this.restClient = template.restClient;
        }
    }

    protected ExternalIdentifiers cloneIterator() {
        return new ConnectedExternalIdentifiers(this);
    }

    protected ElementBase cloneElement(ElementBase template) {
        if (template instanceof ExternalIdentifier) {
            return new ExternalIdentifier((ExternalIdentifier)template);
        }
        return null;
    }

    protected List<ElementBase> getCachedList(int cacheStartPointer, int maximumSize) throws PropertyServerException {
        String methodName = "ExternalIdentifiers.getCachedList";
        String urlTemplate = "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/assets/{3}/external-identifiers?elementStart={4}&maxElements={5}";
        RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
        try {
            ExternalIdentifiersResponse restResult = this.restClient.callOCFExternalIdentifiersGetRESTCall("ExternalIdentifiers.getCachedList", this.omasServerURL + "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/assets/{3}/external-identifiers?elementStart={4}&maxElements={5}", this.serverName, this.serviceName, this.userId, this.assetGUID, cacheStartPointer, maximumSize);
            restExceptionHandler.detectAndThrowInvalidParameterException((FFDCResponse)restResult);
            restExceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponse)restResult);
            restExceptionHandler.detectAndThrowPropertyServerException((FFDCResponse)restResult);
            List beans = restResult.getList();
            if (beans == null || beans.isEmpty()) {
                return null;
            }
            ArrayList<ElementBase> resultList = new ArrayList<ElementBase>();
            for (ExternalIdentifier bean : beans) {
                if (bean == null) continue;
                resultList.add((ElementBase)bean);
            }
            return resultList;
        }
        catch (Exception error) {
            restExceptionHandler.handleUnexpectedException((Throwable)error, "ExternalIdentifiers.getCachedList", this.serverName, this.omasServerURL);
            return null;
        }
    }
}

