/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.NoteLog;
import org.odpi.openmetadata.frameworks.connectors.properties.NoteLogs;
import org.odpi.openmetadata.frameworks.connectors.properties.Notes;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementBase;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.ConnectedNotes;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.rest.NoteLogResponse;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.rest.NoteLogsResponse;

public class ConnectedNoteLogs
extends NoteLogs {
    private static final long serialVersionUID = 1L;
    private String serviceName;
    private String serverName;
    private String userId;
    private String omasServerURL;
    private String assetGUID;
    private OCFRESTClient restClient;

    ConnectedNoteLogs(String serviceName, String serverName, String userId, String omasServerURL, String assetGUID, int totalElementCount, int maxCacheSize, OCFRESTClient restClient) {
        super(totalElementCount, maxCacheSize);
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.userId = userId;
        this.omasServerURL = omasServerURL;
        this.assetGUID = assetGUID;
        this.restClient = restClient;
    }

    private ConnectedNoteLogs(ConnectedNoteLogs template) {
        super((NoteLogs)template);
        if (template != null) {
            this.serviceName = template.serviceName;
            this.serverName = template.serverName;
            this.userId = template.userId;
            this.omasServerURL = template.omasServerURL;
            this.assetGUID = template.assetGUID;
            this.restClient = template.restClient;
        }
    }

    protected NoteLogs cloneIterator() {
        return new ConnectedNoteLogs(this);
    }

    protected List<ElementBase> getCachedList(int cacheStartPointer, int maximumSize) throws PropertyServerException {
        String methodName = "NoteLogs.getCachedList";
        String urlTemplate = "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/assets/{3}/note-logs?elementStart={4}&maxElements={5}";
        RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
        try {
            NoteLogsResponse restResult = this.restClient.callOCFNoteLogsGetRESTCall("NoteLogs.getCachedList", this.omasServerURL + "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/assets/{3}/note-logs?elementStart={4}&maxElements={5}", this.serverName, this.serviceName, this.userId, this.assetGUID, cacheStartPointer, maximumSize);
            restExceptionHandler.detectAndThrowInvalidParameterException((FFDCResponse)restResult);
            restExceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponse)restResult);
            restExceptionHandler.detectAndThrowPropertyServerException((FFDCResponse)restResult);
            List noteLogResponses = restResult.getList();
            if (noteLogResponses == null || noteLogResponses.isEmpty()) {
                return null;
            }
            ArrayList<ElementBase> resultList = new ArrayList<ElementBase>();
            for (NoteLogResponse noteLogResponse : noteLogResponses) {
                if (noteLogResponse == null || noteLogResponse.getNoteLog() == null || noteLogResponse.getNoteCount() <= 0) continue;
                resultList.add((ElementBase)new NoteLog(noteLogResponse.getNoteLog(), (Notes)new ConnectedNotes(this.serviceName, this.serverName, this.userId, this.omasServerURL, noteLogResponse.getNoteLog().getGUID(), noteLogResponse.getNoteCount(), maximumSize, this.restClient)));
            }
            return resultList;
        }
        catch (Exception error) {
            restExceptionHandler.handleUnexpectedException((Throwable)error, "NoteLogs.getCachedList", this.serverName, this.omasServerURL);
            return null;
        }
    }
}

