/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.RelatedMediaReferences;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementBase;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.RelatedMediaReference;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.rest.RelatedMediaReferencesResponse;

public class ConnectedRelatedMediaReferences
extends RelatedMediaReferences {
    private String serviceName;
    private String serverName;
    private String userId;
    private String platformURLRoot;
    private String assetGUID;
    private OCFRESTClient restClient;
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final long serialVersionUID = 1L;

    ConnectedRelatedMediaReferences(String serviceName, String serverName, String userId, String platformURLRoot, String assetGUID, int maxCacheSize, OCFRESTClient restClient) {
        super(maxCacheSize);
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.userId = userId;
        this.platformURLRoot = platformURLRoot;
        this.assetGUID = assetGUID;
        this.restClient = restClient;
    }

    private ConnectedRelatedMediaReferences(ConnectedRelatedMediaReferences template) {
        super((RelatedMediaReferences)template);
        if (template != null) {
            this.serviceName = template.serviceName;
            this.serverName = template.serverName;
            this.userId = template.userId;
            this.platformURLRoot = template.platformURLRoot;
            this.assetGUID = template.assetGUID;
            this.restClient = template.restClient;
        }
    }

    protected RelatedMediaReferences cloneIterator() {
        return new ConnectedRelatedMediaReferences(this);
    }

    protected List<ElementBase> getCachedList(int cacheStartPointer, int maximumSize) throws PropertyServerException {
        String methodName = "RelatedMediaReferences.getCachedList";
        String urlTemplate = "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/assets/{3}/related-media-references?elementStart={4}&maxElements={5}";
        try {
            RelatedMediaReferencesResponse restResult = this.restClient.callOCFRelatedMediaReferencesGetRESTCall("RelatedMediaReferences.getCachedList", this.platformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/assets/{3}/related-media-references?elementStart={4}&maxElements={5}", this.serverName, this.serviceName, this.userId, this.assetGUID, cacheStartPointer, maximumSize);
            this.restExceptionHandler.detectAndThrowInvalidParameterException((FFDCResponse)restResult);
            this.restExceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponse)restResult);
            this.restExceptionHandler.detectAndThrowPropertyServerException((FFDCResponse)restResult);
            List beans = restResult.getList();
            if (beans == null || beans.isEmpty()) {
                return null;
            }
            ArrayList<ElementBase> resultList = new ArrayList<ElementBase>();
            for (RelatedMediaReference bean : beans) {
                if (bean == null) continue;
                resultList.add((ElementBase)bean);
            }
            return resultList;
        }
        catch (Exception error) {
            this.restExceptionHandler.handleUnexpectedException((Throwable)error, "RelatedMediaReferences.getCachedList", this.serverName, this.platformURLRoot);
            return null;
        }
    }
}

