/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client;

import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLoggingComponent;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetUniverse;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectedAssetProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Asset;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.api.ConnectorFactoryInterface;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.ConnectedAssetUniverse;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.EgeriaConnectedAssetProperties;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.ffdc.OMAGOCFErrorCode;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.rest.AssetResponse;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.rest.ConnectionResponse;

public class ConnectedAssetClientBase
implements ConnectorFactoryInterface {
    protected String serverName;
    protected String serverPlatformURLRoot;
    protected AuditLog auditLog;
    protected InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    protected static NullRequestBody nullRequestBody = new NullRequestBody();
    private final String serviceURLMarker;
    private final OCFRESTClient ocfRESTClient;

    public ConnectedAssetClientBase(String serverName, String serverPlatformURLRoot, String serviceURLMarker, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.serviceURLMarker = serviceURLMarker;
        this.auditLog = auditLog;
        this.ocfRESTClient = new OCFRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public ConnectedAssetClientBase(String serverName, String serverPlatformURLRoot, String serviceURLMarker, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.serviceURLMarker = serviceURLMarker;
        this.auditLog = auditLog;
        this.ocfRESTClient = new OCFRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public ConnectedAssetClientBase(String serverName, String serverPlatformURLRoot, String serviceURLMarker) throws InvalidParameterException {
        this(serverName, serverPlatformURLRoot, serviceURLMarker, null);
    }

    public ConnectedAssetClientBase(String serverName, String serverPlatformURLRoot, String serviceURLMarker, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.serviceURLMarker = serviceURLMarker;
        this.auditLog = auditLog;
        this.ocfRESTClient = new OCFRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public ConnectedAssetClientBase(String serverName, String serverPlatformURLRoot, String serviceURLMarker, String userId, String password) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.serviceURLMarker = serviceURLMarker;
        this.ocfRESTClient = new OCFRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    protected Asset getAssetSummary(String userId, String guid, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String urlTemplate = "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/assets/{3}";
        AssetResponse restResult = this.ocfRESTClient.callOCFAssetGetRESTCall(methodName, this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/assets/{3}", this.serverName, this.serviceURLMarker, userId, guid);
        return restResult.getAsset();
    }

    public AssetUniverse getAssetProperties(String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getAssetProperties";
        String guidParameter = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "getAssetProperties");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "getAssetProperties");
        try {
            return ConnectedAssetUniverse.create(this.serviceURLMarker, this.serverName, this.serverPlatformURLRoot, userId, assetGUID);
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException error) {
            throw error;
        }
        catch (Exception error) {
            throw new PropertyServerException(OMAGOCFErrorCode.NO_ASSET_PROPERTIES.getMessageDefinition(new String[]{assetGUID, error.getClass().getName(), error.getMessage()}), this.getClass().getName(), "getAssetProperties");
        }
    }

    protected Connector getConnectorForConnection(OCFRESTClient restClient, String serviceName, String userId, Connection requestedConnection, String methodName) throws ConnectionCheckedException, ConnectorCheckedException {
        ConnectorBroker connectorBroker = new ConnectorBroker(this.auditLog);
        Connector newConnector = connectorBroker.getConnector(requestedConnection);
        if (newConnector == null) {
            throw new ConnectorCheckedException(OMAGOCFErrorCode.NULL_CONNECTOR_RETURNED.getMessageDefinition(new String[]{requestedConnection.getQualifiedName(), serviceName, this.serverName, this.serverPlatformURLRoot}), this.getClass().getName(), methodName);
        }
        try {
            String assetGUID = this.getAssetForConnection(restClient, serviceName, userId, requestedConnection.getGUID());
            EgeriaConnectedAssetProperties connectedAssetProperties = new EgeriaConnectedAssetProperties(serviceName, this.serverName, userId, this.serverPlatformURLRoot, newConnector.getConnectorInstanceId(), newConnector.getConnection(), assetGUID);
            newConnector.initializeConnectedAssetProperties((ConnectedAssetProperties)connectedAssetProperties);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return newConnector;
    }

    protected Connection getConnectionByGUID(OCFRESTClient restClient, String serviceName, String userId, String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getConnectionByGUID";
        String urlTemplate = "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/connections/{3}";
        ConnectionResponse restResult = restClient.callOCFConnectionGetRESTCall("getConnectionByGUID", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/connections/{3}", this.serverName, serviceName, userId, guid);
        return restResult.getConnection();
    }

    protected Connection getConnectionByName(OCFRESTClient restClient, String serviceName, String userId, String name) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getConnectionByName";
        String urlTemplate = "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/connections/by-name/{3}";
        ConnectionResponse restResult = restClient.callOCFConnectionGetRESTCall("getConnectionByName", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/connections/by-name/{3}", this.serverName, serviceName, userId, name);
        return restResult.getConnection();
    }

    public void logAssetAuditMessage(String userId, String assetGUID, String serviceName, String message) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "logAssetAuditMessage";
        String urlTemplate = "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/assets/{3}/log-records/{4}";
        this.ocfRESTClient.callVoidPostRESTCall("logAssetAuditMessage", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/assets/{3}/log-records/{4}", message, new Object[]{this.serverName, this.serviceURLMarker, userId, serviceName});
    }

    public Connection getConnectionForAsset(OCFRESTClient restClient, String serviceName, String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getConnectionForAsset";
        String urlTemplate = "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/assets/{3}/connection";
        ConnectionResponse restResult = restClient.callOCFConnectionGetRESTCall("getConnectionForAsset", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/assets/{3}/connection", this.serverName, serviceName, userId, assetGUID);
        return restResult.getConnection();
    }

    protected String getAssetForConnection(OCFRESTClient restClient, String serviceName, String userId, String connectionGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getAssetForConnection";
        String urlTemplate = "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/assets/by-connection/{3}";
        GUIDResponse restResult = restClient.callGUIDGetRESTCall("getAssetForConnection", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/assets/by-connection/{3}", new Object[]{this.serverName, serviceName, userId, connectionGUID});
        return restResult.getGUID();
    }

    public Asset getAnchorAssetFromGUID(String userId, String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getAnchorAssetFromGUID";
        String guidParameterName = "guid";
        String urlTemplate = "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/assets/from-anchor/{3}";
        this.invalidParameterHandler.validateUserId(userId, "getAnchorAssetFromGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getAnchorAssetFromGUID");
        AssetResponse restResult = this.ocfRESTClient.callOCFAssetGetRESTCall("getAnchorAssetFromGUID", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/assets/from-anchor/{3}", this.serverName, this.serviceURLMarker, userId, guid);
        return restResult.getAsset();
    }

    public String saveConnection(String userId, Connection connection) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, ConnectionCheckedException, ConnectorCheckedException {
        String methodName = "saveConnection";
        String connectionParameterName = "connection";
        String urlTemplate = "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/connections";
        this.invalidParameterHandler.validateUserId(userId, "saveConnection");
        this.invalidParameterHandler.validateObject((Object)connection, "connection", "saveConnection");
        GUIDResponse restResult = this.ocfRESTClient.callGUIDPostRESTCall("saveConnection", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/connections", connection, new Object[]{this.serverName, this.serviceURLMarker, userId});
        return restResult.getGUID();
    }

    public String saveConnection(String userId, String assetGUID, Connection connection) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, ConnectionCheckedException, ConnectorCheckedException {
        String methodName = "saveConnection";
        String connectionParameterName = "connection";
        String assetParameterName = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/connections?assetGUID={3}";
        this.invalidParameterHandler.validateUserId(userId, "saveConnection");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "saveConnection");
        this.invalidParameterHandler.validateObject((Object)connection, "connection", "saveConnection");
        GUIDResponse restResult = this.ocfRESTClient.callGUIDPostRESTCall("saveConnection", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/connections?assetGUID={3}", connection, new Object[]{this.serverName, this.serviceURLMarker, userId, assetGUID});
        return restResult.getGUID();
    }

    public Connector getConnectorByName(String userId, String connectionName) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getConnectorByName";
        String nameParameter = "connectionName";
        this.invalidParameterHandler.validateUserId(userId, "getConnectorByName");
        this.invalidParameterHandler.validateName(connectionName, "connectionName", "getConnectorByName");
        Connection connection = this.getConnectionByName(this.ocfRESTClient, this.serviceURLMarker, userId, connectionName);
        if (connection != null) {
            return this.getConnectorForConnection(this.ocfRESTClient, this.serviceURLMarker, userId, connection, "getConnectorByName");
        }
        return null;
    }

    public Connector getConnectorForAsset(String userId, String assetGUID) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, UserNotAuthorizedException {
        return this.getConnectorForAsset(userId, assetGUID, null);
    }

    public Connector getConnectorForAsset(String userId, String assetGUID, AuditLog auditLog) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getConnectorForAsset";
        String guidParameter = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "getConnectorForAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "getConnectorForAsset");
        Connection connection = this.getConnectionForAsset(this.ocfRESTClient, this.serviceURLMarker, userId, assetGUID);
        if (connection != null) {
            Connector connector = this.getConnectorForConnection(this.ocfRESTClient, this.serviceURLMarker, userId, connection, "getConnectorForAsset");
            if (auditLog != null && connector instanceof AuditLoggingComponent) {
                AuditLoggingComponent auditLoggingComponent = (AuditLoggingComponent)connector;
                auditLoggingComponent.setAuditLog(auditLog);
            }
            return connector;
        }
        return null;
    }

    public Connector getConnectorByGUID(String userId, String connectionGUID) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getConnectorByGUID";
        String guidParameter = "connectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "getConnectorByGUID");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "getConnectorByGUID");
        Connection connection = this.getConnectionByGUID(this.ocfRESTClient, this.serviceURLMarker, userId, connectionGUID);
        if (connection != null) {
            return this.getConnectorForConnection(this.ocfRESTClient, this.serviceURLMarker, userId, connection, "getConnectorByGUID");
        }
        return null;
    }

    public Connector getConnectorByConnection(String userId, Connection connection) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException {
        String methodName = "getConnectorByConnection";
        this.invalidParameterHandler.validateUserId(userId, "getConnectorByConnection");
        return this.getConnectorForConnection(this.ocfRESTClient, this.serviceURLMarker, userId, connection, "getConnectorByConnection");
    }
}

