/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client;

import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.frameworks.connectors.properties.RelatedAssetDetails;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.RelatedAsset;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.ConnectedAssetUniverse;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectedAssetRelatedAssetDetails
extends RelatedAssetDetails {
    private String serviceName;
    private String serverName;
    private String userId = null;
    private String platformURLRoot = null;
    private String assetGUID = null;
    private OCFRESTClient restClient;
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final Logger log = LoggerFactory.getLogger(ConnectedAssetRelatedAssetDetails.class);
    private static final long serialVersionUID = 1L;

    public ConnectedAssetRelatedAssetDetails(RelatedAsset bean, String serviceName, String serverName, String userId, String platformURLRoot, String assetGUID, OCFRESTClient restClient) {
        super(bean);
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.userId = userId;
        this.platformURLRoot = platformURLRoot;
        this.assetGUID = assetGUID;
        this.restClient = restClient;
    }

    public ConnectedAssetRelatedAssetDetails(ConnectedAssetRelatedAssetDetails template) {
        super((RelatedAssetDetails)template);
        if (template != null) {
            this.serviceName = template.serviceName;
            this.serverName = template.serverName;
            this.userId = template.userId;
            this.platformURLRoot = template.platformURLRoot;
            this.assetGUID = template.assetGUID;
            this.restClient = template.restClient;
        }
    }

    public void refresh() throws PropertyServerException, UserNotAuthorizedException {
        String methodName = "refresh";
        String serviceName = "ConnectedAssetRelatedAssetDetails";
        log.debug("Calling method: refresh");
        try {
            this.assetProperties = ConnectedAssetUniverse.create("ConnectedAssetRelatedAssetDetails", this.serverName, this.platformURLRoot, this.userId, this.assetGUID, this.restClient);
        }
        catch (UserNotAuthorizedException error) {
            throw error;
        }
        catch (Exception error) {
            this.restExceptionHandler.handleUnexpectedException(error, "refresh", this.serverName, this.platformURLRoot);
        }
        log.debug("Returning from method: refresh having retrieved: " + this.assetProperties.toString());
    }

    public String toString() {
        return "ConnectedAssetRelatedAssetDetails{userId='" + this.userId + "', platformURLRoot='" + this.platformURLRoot + "', assetGUID='" + this.assetGUID + "', extendedProperties=" + String.valueOf(this.assetProperties) + "}";
    }
}

