/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client;

import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetUniverse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.APISchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ComplexSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.ConnectedAssetLineage;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.ConnectedCertifications;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.ConnectedConnections;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.ConnectedDeployedAPISchemaType;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.ConnectedExternalIdentifiers;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.ConnectedExternalReferences;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.ConnectedFeedback;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.ConnectedLicenses;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.ConnectedNestedSchemaType;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.ConnectedNoteLogs;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.ConnectedRelatedMediaReferences;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.rest.AssetResponse;

public class ConnectedAssetUniverse
extends AssetUniverse {
    private final int MAX_CACHE_SIZE = 100;
    private static final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final long serialVersionUID = 1L;

    private ConnectedAssetUniverse(AssetResponse assetResponse, OCFRESTClient restClient, String serviceName, String remoteServerName, String platformURLRoot, String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        super(assetResponse.getAsset());
        this.processAssetResponse(serviceName, remoteServerName, platformURLRoot, userId, assetGUID, restClient, assetResponse);
    }

    public static ConnectedAssetUniverse create(String serviceName, String remoteServerName, String platformURLRoot, String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        OCFRESTClient restClient = new OCFRESTClient(remoteServerName, platformURLRoot);
        AssetResponse assetResponse = ConnectedAssetUniverse.getAssetSummary(serviceName, remoteServerName, platformURLRoot, restClient, userId, assetGUID);
        return new ConnectedAssetUniverse(assetResponse, restClient, serviceName, remoteServerName, platformURLRoot, userId, assetGUID);
    }

    public static ConnectedAssetUniverse create(String serviceName, String remoteServerName, String localServerUserId, String localServerPassword, String platformURLRoot, String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        OCFRESTClient restClient = new OCFRESTClient(remoteServerName, platformURLRoot, localServerUserId, localServerPassword);
        AssetResponse assetResponse = ConnectedAssetUniverse.getAssetSummary(serviceName, remoteServerName, platformURLRoot, restClient, userId, assetGUID);
        return new ConnectedAssetUniverse(assetResponse, restClient, serviceName, remoteServerName, platformURLRoot, userId, assetGUID);
    }

    public static ConnectedAssetUniverse create(String serviceName, String remoteServerName, String platformURLRoot, String userId, String assetGUID, OCFRESTClient restClient) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        AssetResponse assetResponse = ConnectedAssetUniverse.getAssetSummary(serviceName, remoteServerName, platformURLRoot, restClient, userId, assetGUID);
        return new ConnectedAssetUniverse(assetResponse, restClient, serviceName, remoteServerName, platformURLRoot, userId, assetGUID);
    }

    public static ConnectedAssetUniverse create(String serviceName, String remoteServerName, String platformURLRoot, String userId, String assetGUID, String connectionGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        OCFRESTClient restClient = new OCFRESTClient(remoteServerName, platformURLRoot);
        AssetResponse assetResponse = ConnectedAssetUniverse.getConnectedAssetSummary(serviceName, remoteServerName, platformURLRoot, restClient, userId, assetGUID, connectionGUID);
        return new ConnectedAssetUniverse(assetResponse, restClient, serviceName, remoteServerName, platformURLRoot, userId, assetGUID);
    }

    public static ConnectedAssetUniverse create(String serviceName, String remoteServerName, String localServerUserId, String localServerPassword, String platformURLRoot, String userId, String assetGUID, String connectionGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        OCFRESTClient restClient = new OCFRESTClient(remoteServerName, platformURLRoot, localServerUserId, localServerPassword);
        AssetResponse assetResponse = ConnectedAssetUniverse.getConnectedAssetSummary(serviceName, remoteServerName, platformURLRoot, restClient, userId, assetGUID, connectionGUID);
        return new ConnectedAssetUniverse(assetResponse, restClient, serviceName, remoteServerName, platformURLRoot, userId, assetGUID);
    }

    private void processAssetResponse(String serviceName, String remoteServerName, String platformURLRoot, String userId, String assetGUID, OCFRESTClient restClient, AssetResponse assetResponse) {
        this.externalIdentifiers = new ConnectedExternalIdentifiers(serviceName, remoteServerName, userId, platformURLRoot, assetGUID, 100, restClient);
        this.relatedMediaReferences = new ConnectedRelatedMediaReferences(serviceName, remoteServerName, userId, platformURLRoot, assetGUID, 100, restClient);
        this.noteLogs = new ConnectedNoteLogs(serviceName, remoteServerName, userId, platformURLRoot, assetGUID, 100, restClient);
        this.externalReferences = new ConnectedExternalReferences(serviceName, remoteServerName, userId, platformURLRoot, assetGUID, 100, restClient);
        this.connections = new ConnectedConnections(serviceName, remoteServerName, userId, platformURLRoot, assetGUID, 100, restClient);
        this.licenses = new ConnectedLicenses(serviceName, remoteServerName, userId, platformURLRoot, assetGUID, 100, restClient);
        this.certifications = new ConnectedCertifications(serviceName, remoteServerName, userId, platformURLRoot, assetGUID, 100, restClient);
        this.feedback = new ConnectedFeedback(serviceName, remoteServerName, userId, platformURLRoot, assetGUID, 100, restClient);
        this.lineage = new ConnectedAssetLineage(serviceName, remoteServerName, userId, platformURLRoot, assetGUID, 100, restClient);
        if (assetResponse.getSchemaType() != null) {
            this.schema = this.getSchemaType(serviceName, remoteServerName, platformURLRoot, userId, assetResponse.getSchemaType(), restClient);
        }
    }

    private static AssetResponse getConnectedAssetSummary(String serviceName, String remoteServerName, String platformURLRoot, OCFRESTClient restClient, String userId, String assetGUID, String connectionGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getConnectedAssetSummary";
        String urlTemplate = "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/assets/{3}/via-connection/{4}";
        invalidParameterHandler.validateOMAGServerPlatformURL(platformURLRoot, remoteServerName, "getConnectedAssetSummary");
        AssetResponse restResult = null;
        try {
            restResult = restClient.callOCFAssetGetRESTCall("getConnectedAssetSummary", platformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/assets/{3}/via-connection/{4}", remoteServerName, serviceName, userId, assetGUID, connectionGUID);
            restExceptionHandler.detectAndThrowInvalidParameterException((FFDCResponse)restResult);
            restExceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponse)restResult);
            restExceptionHandler.detectAndThrowPropertyServerException((FFDCResponse)restResult);
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException error) {
            throw error;
        }
        catch (Exception error) {
            restExceptionHandler.handleUnexpectedException(error, "getConnectedAssetSummary", remoteServerName, platformURLRoot);
        }
        return restResult;
    }

    private static AssetResponse getAssetSummary(String serviceURLMarker, String remoteServerName, String platformURLRoot, OCFRESTClient restClient, String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getAssetSummary";
        String urlTemplate = "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/assets/{3}";
        invalidParameterHandler.validateOMAGServerPlatformURL(platformURLRoot, remoteServerName, "getAssetSummary");
        AssetResponse restResult = null;
        try {
            restResult = restClient.callOCFAssetGetRESTCall("getAssetSummary", platformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/assets/{3}", remoteServerName, serviceURLMarker, userId, assetGUID);
            restExceptionHandler.detectAndThrowInvalidParameterException((FFDCResponse)restResult);
            restExceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponse)restResult);
            restExceptionHandler.detectAndThrowPropertyServerException((FFDCResponse)restResult);
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException error) {
            throw error;
        }
        catch (Exception error) {
            restExceptionHandler.handleUnexpectedException(error, "getAssetSummary", remoteServerName, platformURLRoot);
        }
        return restResult;
    }

    private SchemaType getSchemaType(String serviceName, String remoteServerName, String platformURLRoot, String userId, SchemaType bean, OCFRESTClient restClient) {
        if (bean == null) {
            return null;
        }
        if (bean instanceof ComplexSchemaType) {
            return new ConnectedNestedSchemaType((ComplexSchemaType)bean, serviceName, remoteServerName, platformURLRoot, userId, 100, restClient);
        }
        if (bean instanceof APISchemaType) {
            return new ConnectedDeployedAPISchemaType((APISchemaType)bean, serviceName, remoteServerName, platformURLRoot, userId, 100, restClient);
        }
        return bean;
    }
}

