/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.frameworks.connectors.properties.Certifications;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Certification;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementBase;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.rest.CertificationsResponse;

class ConnectedCertifications
extends Certifications {
    private String serviceName;
    private String serverName;
    private String userId;
    private String platformURLRoot;
    private String assetGUID;
    private OCFRESTClient restClient;
    private static final long serialVersionUID = 1L;

    ConnectedCertifications(String serviceName, String serverName, String userId, String platformURLRoot, String assetGUID, int maxCacheSize, OCFRESTClient restClient) {
        super(maxCacheSize);
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.userId = userId;
        this.platformURLRoot = platformURLRoot;
        this.assetGUID = assetGUID;
        this.restClient = restClient;
    }

    private ConnectedCertifications(ConnectedCertifications template) {
        super((Certifications)template);
        if (template != null) {
            this.serviceName = template.serviceName;
            this.serverName = template.serverName;
            this.userId = template.userId;
            this.platformURLRoot = template.platformURLRoot;
            this.assetGUID = template.assetGUID;
            this.restClient = template.restClient;
        }
    }

    protected Certifications cloneIterator() {
        return new ConnectedCertifications(this);
    }

    protected ElementBase cloneElement(ElementBase template) {
        return new Certification((Certification)template);
    }

    protected List<ElementBase> getCachedList(int cacheStartPointer, int maximumSize) throws PropertyServerException {
        String methodName = "Certifications.getCachedList";
        String urlTemplate = "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/assets/{3}/certifications?elementStart={4}&maxElements={5}";
        RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
        try {
            CertificationsResponse restResult = this.restClient.callOCFCertificationsGetRESTCall("Certifications.getCachedList", this.platformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/assets/{3}/certifications?elementStart={4}&maxElements={5}", this.serverName, this.serviceName, this.userId, this.assetGUID, cacheStartPointer, maximumSize);
            restExceptionHandler.detectAndThrowInvalidParameterException((FFDCResponse)restResult);
            restExceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponse)restResult);
            restExceptionHandler.detectAndThrowPropertyServerException((FFDCResponse)restResult);
            List beans = restResult.getList();
            if (beans == null || beans.isEmpty()) {
                return null;
            }
            ArrayList<ElementBase> resultList = new ArrayList<ElementBase>();
            for (Certification bean : beans) {
                if (bean == null) continue;
                resultList.add((ElementBase)new Certification(bean));
            }
            return resultList;
        }
        catch (Exception error) {
            restExceptionHandler.handleUnexpectedException(error, "Certifications.getCachedList", this.serverName, this.platformURLRoot);
            return null;
        }
    }
}

