/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.frameworks.connectors.properties.Notes;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementBase;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Note;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.rest.NotesResponse;

public class ConnectedNotes
extends Notes {
    private String serviceName;
    private String serverName;
    private String userId;
    private String platformURLRoot;
    private String noteLogGUID;
    private OCFRESTClient restClient;
    private static final long serialVersionUID = 1L;

    ConnectedNotes(String serviceName, String serverName, String userId, String platformURLRoot, String noteLogGUID, int maxCacheSize, OCFRESTClient restClient) {
        super(maxCacheSize);
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.userId = userId;
        this.platformURLRoot = platformURLRoot;
        this.noteLogGUID = noteLogGUID;
        this.restClient = restClient;
    }

    private ConnectedNotes(ConnectedNotes template) {
        super((Notes)template);
        if (template != null) {
            this.serviceName = template.serviceName;
            this.serverName = template.serverName;
            this.userId = template.userId;
            this.platformURLRoot = template.platformURLRoot;
            this.noteLogGUID = template.noteLogGUID;
            this.restClient = template.restClient;
        }
    }

    protected Notes cloneIterator() {
        return new ConnectedNotes(this);
    }

    protected List<ElementBase> getCachedList(int cacheStartPointer, int maximumSize) throws PropertyServerException {
        String methodName = "Notes.getCachedList";
        String urlTemplate = "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/note-logs/{3}/notes?elementStart={4}&maxElements={5}";
        RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
        try {
            NotesResponse restResult = this.restClient.callOCFNotesGetRESTCall("Notes.getCachedList", this.platformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/note-logs/{3}/notes?elementStart={4}&maxElements={5}", this.serverName, this.serviceName, this.userId, this.noteLogGUID, cacheStartPointer, maximumSize);
            restExceptionHandler.detectAndThrowInvalidParameterException((FFDCResponse)restResult);
            restExceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponse)restResult);
            restExceptionHandler.detectAndThrowPropertyServerException((FFDCResponse)restResult);
            List beans = restResult.getList();
            if (beans == null || beans.isEmpty()) {
                return null;
            }
            ArrayList<ElementBase> resultList = new ArrayList<ElementBase>();
            for (Note bean : beans) {
                if (bean == null) continue;
                resultList.add((ElementBase)bean);
            }
            return resultList;
        }
        catch (Exception error) {
            restExceptionHandler.handleUnexpectedException(error, "Notes.getCachedList", this.serverName, this.platformURLRoot);
            return null;
        }
    }
}

