/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.frameworks.connectors.properties.SchemaAttributes;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementBase;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttribute;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.rest.SchemaAttributesResponse;

public class ConnectedSchemaAttributes
extends SchemaAttributes {
    private String serviceName;
    private String serverName;
    private String userId;
    private String platformRootURL;
    private String schemaGUID;
    private int maxCacheSize;
    private OCFRESTClient restClient;
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final long serialVersionUID = 1L;

    ConnectedSchemaAttributes(String serviceName, String serverName, String userId, String platformRootURL, String schemaGUID, int maxCacheSize, OCFRESTClient restClient) {
        super(maxCacheSize);
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.userId = userId;
        this.platformRootURL = platformRootURL;
        this.schemaGUID = schemaGUID;
        this.maxCacheSize = maxCacheSize;
        this.restClient = restClient;
    }

    private ConnectedSchemaAttributes(ConnectedSchemaAttributes template) {
        super((SchemaAttributes)template);
        if (template != null) {
            this.serviceName = template.serviceName;
            this.serverName = template.serverName;
            this.userId = template.userId;
            this.platformRootURL = template.platformRootURL;
            this.schemaGUID = template.schemaGUID;
            this.maxCacheSize = template.maxCacheSize;
            this.restClient = template.restClient;
        }
    }

    protected SchemaAttributes cloneIterator() {
        return new ConnectedSchemaAttributes(this);
    }

    protected List<ElementBase> getCachedList(int cacheStartPointer, int maximumSize) throws PropertyServerException {
        String methodName = "SchemaAttributes.getCachedList";
        String urlTemplate = "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/assets/schemas/{3}/schema-attributes?elementStart={4}&maxElements={5}";
        try {
            SchemaAttributesResponse restResult = this.restClient.callOCFSchemaAttributesGetRESTCall("SchemaAttributes.getCachedList", this.platformRootURL + "/servers/{0}/open-metadata/framework-services/{1}/connected-asset/users/{2}/assets/schemas/{3}/schema-attributes?elementStart={4}&maxElements={5}", this.serverName, this.serviceName, this.userId, this.schemaGUID, cacheStartPointer, maximumSize);
            this.restExceptionHandler.detectAndThrowInvalidParameterException((FFDCResponse)restResult);
            this.restExceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponse)restResult);
            this.restExceptionHandler.detectAndThrowPropertyServerException((FFDCResponse)restResult);
            List schemaAttributes = restResult.getList();
            if (schemaAttributes == null || schemaAttributes.isEmpty()) {
                return null;
            }
            ArrayList<ElementBase> resultList = new ArrayList<ElementBase>();
            for (SchemaAttribute schemaAttribute : schemaAttributes) {
                if (schemaAttribute == null) continue;
                resultList.add((ElementBase)new SchemaAttribute(schemaAttribute));
            }
            if (!resultList.isEmpty()) {
                return resultList;
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.handleUnexpectedException(error, "SchemaAttributes.getCachedList", this.serverName, this.platformRootURL);
        }
        return null;
    }
}

