/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.CommentBuilder;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.CommentConverter;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.LastAttachmentHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Comment;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.CommentType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class CommentHandler {
    private String serviceName;
    private String serverName;
    private OMRSRepositoryHelper repositoryHelper;
    private RepositoryHandler repositoryHandler;
    private InvalidParameterHandler invalidParameterHandler;
    private LastAttachmentHandler lastAttachmentHandler;
    private int maxPageSize;

    public CommentHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, LastAttachmentHandler lastAttachmentHandler, int maxPageSize) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHandler = repositoryHandler;
        this.repositoryHelper = repositoryHelper;
        this.lastAttachmentHandler = lastAttachmentHandler;
        this.maxPageSize = maxPageSize;
    }

    private boolean visibleToUser(String userId, Relationship relationship, String methodName) {
        if (userId.equals(relationship.getCreatedBy())) {
            return true;
        }
        return this.repositoryHelper.getBooleanProperty(this.serviceName, "isPublic", relationship.getProperties(), methodName);
    }

    int countAttachedComments(String userId, String anchorGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "anchorGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(anchorGUID, "anchorGUID", methodName);
        List relationships = this.repositoryHandler.getRelationshipsByType(userId, anchorGUID, "Referenceable", "0d90501b-bf29-4621-a207-0c8c953bdac9", "AttachedComment", methodName);
        int count = 0;
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (relationship == null || !this.visibleToUser(userId, relationship, methodName)) continue;
                ++count;
            }
        }
        return count;
    }

    public List<Comment> getComments(String userId, String anchorGUID, String anchorGUIDTypeName, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameter = "anchorGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(anchorGUID, "anchorGUID", methodName);
        List attachedComments = this.repositoryHandler.getPagedRelationshipsByType(userId, anchorGUID, anchorGUIDTypeName, "0d90501b-bf29-4621-a207-0c8c953bdac9", "AttachedComment", startingFrom, pageSize, methodName);
        if (attachedComments == null || attachedComments.isEmpty()) {
            return null;
        }
        ArrayList<Comment> results = new ArrayList<Comment>();
        for (Relationship relationship : attachedComments) {
            Comment bean;
            if (relationship == null || (bean = this.getComment(userId, relationship, methodName)) == null) continue;
            results.add(bean);
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    private Comment getComment(String userId, Relationship relationship, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityProxy entityProxy;
        String guidParameterName = "referenceableRatingRelationship.end2.guid";
        if (relationship != null && this.visibleToUser(userId, relationship, methodName) && (entityProxy = relationship.getEntityTwoProxy()) != null) {
            EntityDetail entity = this.repositoryHandler.getEntityByGUID(userId, entityProxy.getGUID(), "referenceableRatingRelationship.end2.guid", "Comment", methodName);
            CommentConverter converter = new CommentConverter(entity, relationship, this.repositoryHelper, this.serviceName);
            return converter.getBean();
        }
        return null;
    }

    private String attachNewComment(String userId, String anchorGUID, String guidParameter, CommentType commentType, String commentText, boolean isPublic, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String typeParameter = "commentType";
        String textParameter = "commentText";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(anchorGUID, guidParameter, methodName);
        this.invalidParameterHandler.validateEnum((Object)commentType, "commentType", methodName);
        this.invalidParameterHandler.validateText(commentText, "commentText", methodName);
        this.repositoryHandler.validateEntityGUID(userId, anchorGUID, "Asset", methodName, guidParameter);
        CommentBuilder builder = new CommentBuilder(commentType, commentText, isPublic, anchorGUID, this.repositoryHelper, this.serviceName, this.serverName);
        String commentGUID = this.repositoryHandler.createEntity(userId, "1a226073-9c84-40e4-a422-fbddb9b84278", "Comment", builder.getEntityInstanceProperties(methodName), methodName);
        if (commentGUID != null) {
            this.repositoryHandler.createRelationship(userId, "0d90501b-bf29-4621-a207-0c8c953bdac9", anchorGUID, commentGUID, builder.getRelationshipInstanceProperties(methodName), methodName);
        }
        return commentGUID;
    }

    public String addCommentToReferenceable(String userId, String anchorGUID, String anchorType, CommentType commentType, String commentText, boolean isPublic, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameter = "anchorGUID";
        String commentDescription = "New comment from ";
        String commentGUID = this.attachNewComment(userId, anchorGUID, "anchorGUID", commentType, commentText, isPublic, methodName);
        this.lastAttachmentHandler.updateLastAttachment(anchorGUID, anchorType, commentGUID, "Comment", userId, "New comment from " + userId, methodName);
        return commentGUID;
    }

    public String addCommentReplyToReferenceable(String userId, String anchorGUID, String anchorType, String attachmentGUID, CommentType commentType, String commentText, boolean isPublic, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameter = "attachmentGUID";
        String commentDescription = "New comment reply from ";
        String commentGUID = this.attachNewComment(userId, attachmentGUID, "attachmentGUID", commentType, commentText, isPublic, methodName);
        this.lastAttachmentHandler.updateLastAttachment(anchorGUID, anchorType, commentGUID, "Comment", userId, "New comment reply from " + userId, methodName);
        return commentGUID;
    }

    public void updateComment(String userId, String anchorGUID, String anchorType, String commentGUID, CommentType commentType, String commentText, boolean isPublic, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String typeParameter = "commentType";
        String textParameter = "commentText";
        String guidParameter = "commentGUID";
        String commentDescription = "Updated comment from ";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(commentGUID, "commentGUID", methodName);
        this.invalidParameterHandler.validateEnum((Object)commentType, "commentType", methodName);
        this.invalidParameterHandler.validateText(commentText, "commentText", methodName);
        this.repositoryHandler.validateEntityGUID(userId, commentGUID, "Comment", methodName, "commentGUID");
        CommentBuilder builder = new CommentBuilder(commentType, commentText, isPublic, anchorGUID, this.repositoryHelper, this.serviceName, this.serverName);
        this.repositoryHandler.updateEntity(userId, commentGUID, "1a226073-9c84-40e4-a422-fbddb9b84278", "Comment", builder.getEntityInstanceProperties(methodName), methodName);
        this.lastAttachmentHandler.updateLastAttachment(anchorGUID, anchorType, commentGUID, "Comment", userId, "Updated comment from " + userId, methodName);
    }

    public void removeCommentFromReferenceable(String userId, String anchorGUID, String anchorType, String commentGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String commentDescription = "Removed comment from ";
        this.repositoryHandler.removeEntity(userId, commentGUID, "1a226073-9c84-40e4-a422-fbddb9b84278", "Comment", null, null, methodName);
        this.lastAttachmentHandler.updateLastAttachment(anchorGUID, anchorType, commentGUID, "Comment", userId, "Removed comment from " + userId, methodName);
    }
}

