/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders;

import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.RootBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.StarRating;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class RatingBuilder
extends RootBuilder {
    private StarRating starRating;
    private String review;
    private boolean isPublic;
    private String anchorGUID;

    public RatingBuilder(StarRating starRating, String review, boolean isPublic, String anchorGUID, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
        this.starRating = starRating;
        this.review = review;
        this.isPublic = isPublic;
        this.anchorGUID = anchorGUID;
    }

    public InstanceProperties getRelationshipInstanceProperties(String methodName) {
        return this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, null, "isPublic", this.isPublic, methodName);
    }

    public InstanceProperties getEntityInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        if (this.starRating != null) {
            properties = this.addStarRatingPropertyToInstance(properties, this.starRating, methodName);
        }
        if (this.review != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "review", this.review, methodName);
        }
        if (this.anchorGUID != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "anchorGUID", this.anchorGUID, methodName);
        }
        return properties;
    }

    private InstanceProperties addStarRatingPropertyToInstance(InstanceProperties properties, StarRating starRating, String methodName) {
        int ordinal = 99;
        String symbolicName = null;
        String description = null;
        boolean element1Ordinal = false;
        String element1Value = "NotRecommended";
        String element1Description = "This content is not recommended.";
        boolean element2Ordinal = true;
        String element2Value = "OneStar";
        String element2Description = "One star rating.";
        int element3Ordinal = 2;
        String element3Value = "TwoStar";
        String element3Description = "Two star rating.";
        int element4Ordinal = 3;
        String element4Value = "ThreeStar";
        String element4Description = "Three star rating.";
        int element5Ordinal = 4;
        String element5Value = "FourStar";
        String element5Description = "Four star rating.";
        int element6Ordinal = 5;
        String element6Value = "FiveStar";
        String element6Description = "Five star rating.";
        switch (starRating) {
            case NOT_RECOMMENDED: {
                ordinal = 0;
                symbolicName = "NotRecommended";
                description = "This content is not recommended.";
                break;
            }
            case ONE_STAR: {
                ordinal = 1;
                symbolicName = "OneStar";
                description = "One star rating.";
                break;
            }
            case TWO_STARS: {
                ordinal = 2;
                symbolicName = "TwoStar";
                description = "Two star rating.";
                break;
            }
            case THREE_STARS: {
                ordinal = 3;
                symbolicName = "ThreeStar";
                description = "Three star rating.";
                break;
            }
            case FOUR_STARS: {
                ordinal = 4;
                symbolicName = "FourStar";
                description = "Four star rating.";
                break;
            }
            case FIVE_STARS: {
                ordinal = 5;
                symbolicName = "FiveStar";
                description = "Five star rating.";
            }
        }
        return this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, "stars", ordinal, symbolicName, description, methodName);
    }
}

