/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders;

import java.util.Map;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.RootBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ReferenceableBuilder
extends RootBuilder {
    protected String qualifiedName;
    private Map<String, String> additionalProperties = null;
    private Map<String, Object> extendedProperties = null;

    protected ReferenceableBuilder(String qualifiedName, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
        this.qualifiedName = qualifiedName;
    }

    protected ReferenceableBuilder(String qualifiedName, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        this(qualifiedName, repositoryHelper, serviceName, serverName);
        this.additionalProperties = additionalProperties;
        this.extendedProperties = extendedProperties;
    }

    @Override
    protected InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = null;
        if (this.extendedProperties != null) {
            try {
                properties = this.repositoryHelper.addPropertyMapToInstance(this.serviceName, null, this.extendedProperties, methodName);
            }
            catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException error) {
                String propertyName = "extendedProperties";
                this.errorHandler.handleUnsupportedProperty((Throwable)error, methodName, "extendedProperties");
            }
        }
        if (this.qualifiedName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "qualifiedName", this.qualifiedName, methodName);
        }
        if (this.additionalProperties != null) {
            properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, "additionalProperties", this.additionalProperties, methodName);
        }
        return properties;
    }

    public InstanceProperties getNameInstanceProperties(String methodName) {
        InstanceProperties properties = null;
        if (this.qualifiedName != null) {
            String literalQualifiedName = this.repositoryHelper.getExactMatchRegex(this.qualifiedName);
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "qualifiedName", literalQualifiedName, methodName);
        }
        return properties;
    }

    public InstanceProperties getQualifiedNameInstanceProperties(String methodName) {
        return this.getNameInstanceProperties(methodName);
    }
}

