/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders;

import java.util.Map;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SchemaTypeBuilder
extends ReferenceableBuilder {
    private String displayName;
    private String versionNumber;
    private String author = null;
    private String usage = null;
    private String encodingStandard = null;

    public SchemaTypeBuilder(String qualifiedName, String displayName, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
    }

    public SchemaTypeBuilder(String qualifiedName, String displayName, String versionNumber, String author, String usage, String encodingStandard, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, extendedProperties, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.versionNumber = versionNumber;
        this.author = author;
        this.usage = usage;
        this.encodingStandard = encodingStandard;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        if (this.displayName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "displayName", this.displayName, methodName);
        }
        if (this.versionNumber != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "versionNumber", this.versionNumber, methodName);
        }
        if (this.author != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "author", this.author, methodName);
        }
        if (this.usage != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "usage", this.usage, methodName);
        }
        if (this.encodingStandard != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "encodingStandard", this.encodingStandard, methodName);
        }
        return properties;
    }

    @Override
    public InstanceProperties getNameInstanceProperties(String methodName) {
        InstanceProperties properties = super.getNameInstanceProperties(methodName);
        if (this.displayName != null) {
            String literalName = this.repositoryHelper.getExactMatchRegex(this.displayName);
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "displayName", literalName, methodName);
        }
        return properties;
    }

    @Override
    public InstanceProperties getQualifiedNameInstanceProperties(String methodName) {
        return super.getNameInstanceProperties(methodName);
    }
}

