/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters;

import java.util.List;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.ReferenceableConverter;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Referenceable;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttribute;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttributeRelationship;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaLink;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SchemaAttributeConverter
extends ReferenceableConverter {
    private SchemaType attributeType;
    private SchemaLink externalAttributeType;
    private List<SchemaAttributeRelationship> attributeRelationships;

    public SchemaAttributeConverter(EntityDetail mainEntity, SchemaType attributeType, SchemaLink externalAttributeType, List<SchemaAttributeRelationship> attributeRelationships, OMRSRepositoryHelper repositoryHelper, String serviceName) {
        super(mainEntity, repositoryHelper, serviceName);
        this.attributeType = attributeType;
        this.externalAttributeType = externalAttributeType;
        this.attributeRelationships = attributeRelationships;
    }

    public SchemaAttribute getBean() {
        String methodName = "getBean";
        SchemaAttribute bean = null;
        if (this.entity != null) {
            bean = new SchemaAttribute();
            super.updateBean((Referenceable)bean);
            bean.setAttributeType(this.attributeType);
            bean.setExternalAttributeType(this.externalAttributeType);
            bean.setAttributeRelationships(this.attributeRelationships);
            InstanceProperties instanceProperties = this.entity.getProperties();
            if (instanceProperties != null) {
                bean.setAttributeName(this.repositoryHelper.removeStringProperty(this.serviceName, "displayName", instanceProperties, "getBean"));
                if (bean.getAttributeName() == null) {
                    bean.setAttributeName(this.repositoryHelper.removeStringProperty(this.serviceName, "name", instanceProperties, "getBean"));
                }
                bean.setElementPosition(this.repositoryHelper.removeIntProperty(this.serviceName, "position", instanceProperties, "getBean"));
                bean.setCardinality(this.repositoryHelper.removeStringProperty(this.serviceName, "cardinality", instanceProperties, "getBean"));
                bean.setDefaultValueOverride(this.repositoryHelper.removeStringProperty(this.serviceName, "defaultValueOverride", instanceProperties, "getBean"));
                bean.setAdditionalProperties(this.repositoryHelper.removeStringMapFromProperty(this.serviceName, "additionalProperties", instanceProperties, "getBean"));
                bean.setExtendedProperties(this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties));
            }
        }
        return bean;
    }
}

