/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.InformalTagBuilder;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.InformalTagConverter;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.FeedbackHandlerBase;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.LastAttachmentHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.InformalTag;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class InformalTagHandler
extends FeedbackHandlerBase {
    public InformalTagHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, LastAttachmentHandler lastAttachmentHandler) {
        super(serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, lastAttachmentHandler);
    }

    public int countTags(String userId, String anchorGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.countAttachments(userId, anchorGUID, "Referenceable", "4b1641c4-3d1a-4213-86b2-d6968b6c65ab", "AttachedTag", methodName);
    }

    public List<InformalTag> getAttachedTags(String userId, String anchorGUID, String anchorTypeName, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<Relationship> relationships = super.getAttachmentLinks(userId, anchorGUID, anchorTypeName, "4b1641c4-3d1a-4213-86b2-d6968b6c65ab", "AttachedTag", startingFrom, pageSize, methodName);
        if (relationships == null || relationships.isEmpty()) {
            return null;
        }
        ArrayList<InformalTag> results = new ArrayList<InformalTag>();
        for (Relationship relationship : relationships) {
            InformalTag bean;
            if (relationship == null || (bean = this.getTag(userId, relationship, methodName)) == null) continue;
            results.add(bean);
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    private InformalTag getTag(String userId, Relationship relationship, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityProxy entityProxy;
        String guidParameterName = "relationship.end2.guid";
        if (relationship != null && (entityProxy = relationship.getEntityTwoProxy()) != null) {
            EntityDetail entity = this.repositoryHandler.getEntityByGUID(userId, entityProxy.getGUID(), "relationship.end2.guid", "InformalTag", methodName);
            InformalTagConverter converter = new InformalTagConverter(entity, relationship, this.repositoryHelper, this.serviceName);
            return converter.getBean();
        }
        return null;
    }

    public String createTag(String userId, String tagName, String tagDescription, boolean isPublic, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nameParameter = "tagName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(tagName, "tagName", methodName);
        InformalTagBuilder builder = new InformalTagBuilder(tagName, tagDescription, isPublic, userId, this.repositoryHelper, this.serviceName, this.serverName);
        return this.repositoryHandler.createEntity(userId, "ba846a7b-2955-40bf-952b-2793ceca090a", "InformalTag", builder.getInstanceProperties(methodName), methodName);
    }

    public void updateTagDescription(String userId, String tagGUID, String tagDescription, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        InformalTag tag = this.getTag(userId, tagGUID, methodName);
        InformalTagBuilder builder = new InformalTagBuilder(tag.getName(), tagDescription, tag.isPublic(), tag.getUser(), this.repositoryHelper, this.serviceName, this.serverName);
        this.repositoryHandler.updateEntity(userId, tagGUID, "ba846a7b-2955-40bf-952b-2793ceca090a", "InformalTag", builder.getInstanceProperties(methodName), methodName);
    }

    public void deleteTag(String userId, String tagGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        InformalTag tag = this.getTag(userId, tagGUID, methodName);
        if (tag != null) {
            if (tag.isPrivateTag()) {
                this.repositoryHandler.removeEntity(userId, tagGUID, "ba846a7b-2955-40bf-952b-2793ceca090a", "InformalTag", null, null, methodName);
            } else if (this.repositoryHandler.countAttachedRelationshipsByType(userId, tagGUID, "InformalTag", "4b1641c4-3d1a-4213-86b2-d6968b6c65ab", "AttachedTag", methodName) == 0) {
                this.repositoryHandler.removeEntity(userId, tagGUID, "ba846a7b-2955-40bf-952b-2793ceca090a", "InformalTag", null, null, methodName);
            } else {
                this.invalidParameterHandler.throwCannotDeleteElementInUse(tagGUID, "InformalTag", this.serviceName, methodName);
            }
        }
    }

    public InformalTag getTag(String userId, String guid, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String tagGUIDParameterName = "guid";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(guid, "guid", methodName);
        EntityDetail tagEntity = this.repositoryHandler.getEntityByGUID(userId, guid, "guid", "InformalTag", methodName);
        if (tagEntity != null) {
            InformalTagConverter converter = new InformalTagConverter(tagEntity, this.repositoryHelper, this.serviceName);
            InformalTag tag = converter.getBean();
            if (tag.isPrivateTag()) {
                if (userId.equals(tag.getUser())) {
                    return tag;
                }
            } else {
                return tag;
            }
        }
        return null;
    }

    public List<InformalTag> getTagsByName(String userId, String name, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nameParameterName = "name";
        this.invalidParameterHandler.validateName(name, "name", methodName);
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        InformalTagBuilder builder = new InformalTagBuilder(name, userId, this.repositoryHelper, this.serviceName, this.serverName);
        List<InformalTag> results = new ArrayList<InformalTag>();
        boolean moreResultsAvailable = true;
        int startNextQueryFrom = startFrom;
        while (moreResultsAvailable && results.size() < pageSize) {
            List retrievedEntities = this.repositoryHandler.getEntitiesByName(userId, builder.getNameInstanceProperties(methodName), "ba846a7b-2955-40bf-952b-2793ceca090a", startNextQueryFrom, pageSize, methodName);
            if (retrievedEntities != null) {
                results = this.getTagList(userId, retrievedEntities, results, pageSize);
                moreResultsAvailable = retrievedEntities.size() == pageSize;
                startNextQueryFrom += pageSize;
                continue;
            }
            moreResultsAvailable = false;
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<InformalTag> getMyTagsByName(String userId, String name, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nameParameterName = "name";
        this.invalidParameterHandler.validateName(name, "name", methodName);
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        InformalTagBuilder builder = new InformalTagBuilder(name, userId, this.repositoryHelper, this.serviceName, this.serverName);
        List<InformalTag> results = new ArrayList<InformalTag>();
        boolean moreResultsAvailable = true;
        int startNextQueryFrom = startFrom;
        while (moreResultsAvailable && results.size() < pageSize) {
            List retrievedEntities = this.repositoryHandler.getEntitiesByAllProperties(userId, builder.getUserNameInstanceProperties(methodName), "ba846a7b-2955-40bf-952b-2793ceca090a", startNextQueryFrom, pageSize, methodName);
            if (retrievedEntities != null) {
                results = this.getMyTagList(retrievedEntities, results, pageSize);
                moreResultsAvailable = retrievedEntities.size() == pageSize;
                startNextQueryFrom += pageSize;
                continue;
            }
            moreResultsAvailable = false;
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<InformalTag> findTags(String userId, String searchString, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nameParameterName = "searchString";
        this.invalidParameterHandler.validateName(searchString, "searchString", methodName);
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        InformalTagBuilder builder = new InformalTagBuilder(searchString, searchString, this.repositoryHelper, this.serviceName, this.serverName);
        List<InformalTag> results = new ArrayList<InformalTag>();
        boolean moreResultsAvailable = true;
        int startNextQueryFrom = startFrom;
        while (moreResultsAvailable && results.size() < pageSize) {
            List retrievedEntities = this.repositoryHandler.getEntitiesByName(userId, builder.getSearchInstanceProperties(methodName), "ba846a7b-2955-40bf-952b-2793ceca090a", startNextQueryFrom, pageSize, methodName);
            if (retrievedEntities != null) {
                results = this.getTagList(userId, retrievedEntities, results, pageSize);
                moreResultsAvailable = retrievedEntities.size() == pageSize;
                startNextQueryFrom += pageSize;
                continue;
            }
            moreResultsAvailable = false;
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<InformalTag> findMyTags(String userId, String searchString, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nameParameterName = "searchString";
        this.invalidParameterHandler.validateName(searchString, "searchString", methodName);
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        InformalTagBuilder builder = new InformalTagBuilder(searchString, searchString, this.repositoryHelper, this.serviceName, this.serverName);
        List<InformalTag> results = new ArrayList<InformalTag>();
        boolean moreResultsAvailable = true;
        int startNextQueryFrom = startFrom;
        while (moreResultsAvailable && results.size() < pageSize) {
            List retrievedEntities = this.repositoryHandler.getEntitiesByAllProperties(userId, builder.getUserSearchInstanceProperties(methodName), "ba846a7b-2955-40bf-952b-2793ceca090a", startNextQueryFrom, pageSize, methodName);
            if (retrievedEntities != null) {
                results = this.getTagList(userId, retrievedEntities, results, pageSize);
                moreResultsAvailable = retrievedEntities.size() == pageSize;
                startNextQueryFrom += pageSize;
                continue;
            }
            moreResultsAvailable = false;
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    private List<InformalTag> getTagList(String userId, List<EntityDetail> retrievedEntities, List<InformalTag> currentTagList, int maxPageSize) {
        List<InformalTag> results = currentTagList;
        if (results == null) {
            results = new ArrayList<InformalTag>();
        }
        if (retrievedEntities != null) {
            for (EntityDetail entity : retrievedEntities) {
                if (entity == null || results.size() >= maxPageSize) continue;
                InformalTagConverter converter = new InformalTagConverter(entity, null, this.repositoryHelper, this.serviceName);
                InformalTag informalTag = converter.getBean();
                try {
                    if (informalTag == null || informalTag.isPrivateTag() && !userId.equals(informalTag.getUser())) continue;
                    results.add(informalTag);
                }
                catch (Throwable throwable) {}
            }
        }
        return results;
    }

    private List<InformalTag> getMyTagList(List<EntityDetail> retrievedEntities, List<InformalTag> currentTagList, int maxPageSize) {
        List<InformalTag> results = currentTagList;
        if (results == null) {
            results = new ArrayList<InformalTag>();
        }
        if (retrievedEntities != null) {
            for (EntityDetail entity : retrievedEntities) {
                if (entity == null || results.size() >= maxPageSize) continue;
                InformalTagConverter converter = new InformalTagConverter(entity, null, this.repositoryHelper, this.serviceName);
                InformalTag informalTag = converter.getBean();
                try {
                    if (informalTag == null || !informalTag.isPrivateTag()) continue;
                    results.add(informalTag);
                }
                catch (Throwable throwable) {}
            }
        }
        return results;
    }

    public void addTagToAnchor(String userId, String anchorGUID, String anchorType, String tagGUID, boolean isPublic, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String tagGUIDParameterName = "tagGUID";
        String anchorGUIDParameterName = "anchorGUID";
        String lastAttachmentDescription = "Added informal tag to ";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(tagGUID, "tagGUID", methodName);
        this.invalidParameterHandler.validateGUID(anchorGUID, "anchorGUID", methodName);
        this.repositoryHandler.validateEntityGUID(userId, anchorGUID, anchorType, methodName, "anchorGUID");
        this.repositoryHandler.validateEntityGUID(userId, tagGUID, "InformalTag", methodName, "tagGUID");
        InstanceProperties properties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, null, "isPublic", isPublic, methodName);
        this.repositoryHandler.createRelationship(userId, "4b1641c4-3d1a-4213-86b2-d6968b6c65ab", anchorGUID, tagGUID, properties, methodName);
        if (isPublic) {
            this.lastAttachmentHandler.updateLastAttachment(anchorGUID, anchorType, tagGUID, "InformalTag", userId, "Added informal tag to " + tagGUID, methodName);
        }
    }

    public void removeTagFromAnchor(String userId, String anchorGUID, String anchorType, String tagGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String tagGUIDParameterName = "tagGUID";
        String assetGUIDParameterName = "anchorGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(tagGUID, "tagGUID", methodName);
        this.invalidParameterHandler.validateGUID(anchorGUID, "anchorGUID", methodName);
        this.repositoryHandler.validateEntityGUID(userId, anchorGUID, anchorType, methodName, "anchorGUID");
        InformalTag tag = this.getTag(userId, tagGUID, methodName);
        this.repositoryHandler.removeRelationshipBetweenEntities(userId, "4b1641c4-3d1a-4213-86b2-d6968b6c65ab", "AttachedTag", anchorGUID, "Asset", tagGUID, methodName);
        if (!tag.isPrivateTag()) {
            this.lastAttachmentHandler.updateLastAttachment(anchorGUID, anchorType, tagGUID, "InformalTag", userId, "Remove tag " + tagGUID, methodName);
        }
    }
}

