/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.ReferenceableConverter;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Referenceable;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ReferenceableHandler {
    private String serviceName;
    private String serverName;
    private OMRSRepositoryHelper repositoryHelper;
    private RepositoryHandler repositoryHandler;
    private InvalidParameterHandler invalidParameterHandler;

    public ReferenceableHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHandler = repositoryHandler;
        this.repositoryHelper = repositoryHelper;
    }

    public List<Referenceable> getMoreInformation(String userId, String elementGUID, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        List entitiesForRelationshipType = this.repositoryHandler.getEntitiesForRelationshipType(userId, elementGUID, "Referenceable", "1cbf059e-2c11-4e0c-8aae-1da42c1ee73f", "MoreInformation", startFrom, pageSize, methodName);
        if (entitiesForRelationshipType != null) {
            ArrayList<Referenceable> moreInfoElements = new ArrayList<Referenceable>();
            for (EntityDetail entity : entitiesForRelationshipType) {
                if (entity == null) continue;
                ReferenceableConverter converter = new ReferenceableConverter(entity, this.repositoryHelper, this.serviceName);
                moreInfoElements.add(converter.getBean());
            }
            if (moreInfoElements.isEmpty()) {
                return null;
            }
            return moreInfoElements;
        }
        return null;
    }
}

