/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders;

import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.RootBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class InformalTagBuilder
extends RootBuilder {
    private String tagName;
    private String tagDescription;
    private boolean isPublic;
    private String user;

    public InformalTagBuilder(String tagName, String user, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
        this.tagName = tagName;
        this.user = user;
    }

    public InformalTagBuilder(String tagName, String tagDescription, String user, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
        this.tagName = tagName;
        this.tagDescription = tagDescription;
        this.user = user;
    }

    public InformalTagBuilder(String tagName, String tagDescription, boolean isPublic, String user, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
        this.tagName = tagName;
        this.tagDescription = tagDescription;
        this.isPublic = isPublic;
        this.user = user;
    }

    public InstanceProperties getNameInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        if (this.tagName != null) {
            String literalName = this.repositoryHelper.getExactMatchRegex(this.tagName);
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "tagName", literalName, methodName);
        }
        return properties;
    }

    public InstanceProperties getUserNameInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        if (this.tagName != null) {
            String literalName = this.repositoryHelper.getExactMatchRegex(this.tagName);
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "tagName", literalName, methodName);
        }
        if (this.user != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "createdBy", this.user, methodName);
        }
        return properties;
    }

    public InstanceProperties getSearchInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        if (this.tagName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "tagName", this.tagName, methodName);
        }
        if (this.tagDescription != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "tagDescription", this.tagDescription, methodName);
        }
        if (this.user != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "createdBy", this.user, methodName);
        }
        return properties;
    }

    public InstanceProperties getUserSearchInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        if (this.tagName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "tagName", this.tagName, methodName);
        }
        if (this.tagDescription != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "tagDescription", this.tagDescription, methodName);
        }
        return properties;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        if (this.tagName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "tagName", this.tagName, methodName);
        }
        if (this.tagDescription != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "tagDescription", this.tagDescription, methodName);
        }
        properties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, properties, "isPublic", this.isPublic, methodName);
        return properties;
    }
}

